/* Copyright (c) 2021, 2025, Oracle and/or its affiliates.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License, version 2.0,
   as published by the Free Software Foundation.

   This program is designed to work with certain software (including
   but not limited to OpenSSL) that is licensed under separate terms,
   as designated in a particular file or component or in included license
   documentation.  The authors of MySQL hereby grant you an additional
   permission to link the program and your derivative works with the
   separately licensed software that they have either included with
   the program or referenced in the documentation.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License, version 2.0, for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA */

#include "xcom/leader_info_data.h" /* leader_info_data */

// Essentially a move constructor, implemented before we switched to C++
// This purely an optimization. Instead of first cloning the contents of from,
// and then deallocate from by calling xdr_free, and then return the contents of
// from, we simply steal the contents and reset from so it can be deallocated
// without touching the contents.
leader_info_data steal_leader_info_data(leader_info_data &from) {
  leader_info_data new_owner = from;

  from.max_nr_leaders = 0;
  from.actual_leaders.leader_array_len = 0;
  from.actual_leaders.leader_array_val = nullptr;
  from.preferred_leaders.leader_array_len = 0;
  from.preferred_leaders.leader_array_val = nullptr;

  return new_owner;
}
