/* xoreos-tools - Tools to help with xoreos development
 *
 * xoreos-tools is the legal property of its developers, whose names
 * can be found in the AUTHORS file distributed with this source
 * distribution.
 *
 * xoreos-tools is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * xoreos-tools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xoreos-tools. If not, see <http://www.gnu.org/licenses/>.
 */

/** @file
 *  Game-specific NWScript information for Neverwinter Nights 2.
 */

#ifndef NWSCRIPT_GAME_NWN2_H
#define NWSCRIPT_GAME_NWN2_H

#include "src/nwscript/game.h"

namespace NWScript {

namespace NWN2 {

static const char * const kEngineTypeNames[] = {
	"Effect", "Event", "Location", "Talent", "ItemProperty"
};

static const char * const kFunctionNames[] = {
	/*    0 */ "Random",
	/*    1 */ "PrintString",
	/*    2 */ "PrintFloat",
	/*    3 */ "FloatToString",
	/*    4 */ "PrintInteger",
	/*    5 */ "PrintObject",
	/*    6 */ "AssignCommand",
	/*    7 */ "DelayCommand",
	/*    8 */ "ExecuteScript",
	/*    9 */ "ClearAllActions",
	/*   10 */ "SetFacing",
	/*   11 */ "SetCalendar",
	/*   12 */ "SetTime",
	/*   13 */ "GetCalendarYear",
	/*   14 */ "GetCalendarMonth",
	/*   15 */ "GetCalendarDay",
	/*   16 */ "GetTimeHour",
	/*   17 */ "GetTimeMinute",
	/*   18 */ "GetTimeSecond",
	/*   19 */ "GetTimeMillisecond",
	/*   20 */ "ActionRandomWalk",
	/*   21 */ "ActionMoveToLocation",
	/*   22 */ "ActionMoveToObject",
	/*   23 */ "ActionMoveAwayFromObject",
	/*   24 */ "GetArea",
	/*   25 */ "GetEnteringObject",
	/*   26 */ "GetExitingObject",
	/*   27 */ "GetPosition",
	/*   28 */ "GetFacing",
	/*   29 */ "GetItemPossessor",
	/*   30 */ "GetItemPossessedBy",
	/*   31 */ "CreateItemOnObject",
	/*   32 */ "ActionEquipItem",
	/*   33 */ "ActionUnequipItem",
	/*   34 */ "ActionPickUpItem",
	/*   35 */ "ActionPutDownItem",
	/*   36 */ "GetLastAttacker",
	/*   37 */ "ActionAttack",
	/*   38 */ "GetNearestCreature",
	/*   39 */ "ActionSpeakString",
	/*   40 */ "ActionPlayAnimation",
	/*   41 */ "GetDistanceToObject",
	/*   42 */ "GetIsObjectValid",
	/*   43 */ "ActionOpenDoor",
	/*   44 */ "ActionCloseDoor",
	/*   45 */ "SetCameraFacing",
	/*   46 */ "PlaySound",
	/*   47 */ "GetSpellTargetObject",
	/*   48 */ "ActionCastSpellAtObject",
	/*   49 */ "GetCurrentHitPoints",
	/*   50 */ "GetMaxHitPoints",
	/*   51 */ "GetLocalInt",
	/*   52 */ "GetLocalFloat",
	/*   53 */ "GetLocalString",
	/*   54 */ "GetLocalObject",
	/*   55 */ "SetLocalInt",
	/*   56 */ "SetLocalFloat",
	/*   57 */ "SetLocalString",
	/*   58 */ "SetLocalObject",
	/*   59 */ "GetStringLength",
	/*   60 */ "GetStringUpperCase",
	/*   61 */ "GetStringLowerCase",
	/*   62 */ "GetStringRight",
	/*   63 */ "GetStringLeft",
	/*   64 */ "InsertString",
	/*   65 */ "GetSubString",
	/*   66 */ "FindSubString",
	/*   67 */ "fabs",
	/*   68 */ "cos",
	/*   69 */ "sin",
	/*   70 */ "tan",
	/*   71 */ "acos",
	/*   72 */ "asin",
	/*   73 */ "atan",
	/*   74 */ "log",
	/*   75 */ "pow",
	/*   76 */ "sqrt",
	/*   77 */ "abs",
	/*   78 */ "EffectHeal",
	/*   79 */ "EffectDamage",
	/*   80 */ "EffectAbilityIncrease",
	/*   81 */ "EffectDamageResistance",
	/*   82 */ "EffectResurrection",
	/*   83 */ "EffectSummonCreature",
	/*   84 */ "GetCasterLevel",
	/*   85 */ "GetFirstEffect",
	/*   86 */ "GetNextEffect",
	/*   87 */ "RemoveEffect",
	/*   88 */ "GetIsEffectValid",
	/*   89 */ "GetEffectDurationType",
	/*   90 */ "GetEffectSubType",
	/*   91 */ "GetEffectCreator",
	/*   92 */ "IntToString",
	/*   93 */ "GetFirstObjectInArea",
	/*   94 */ "GetNextObjectInArea",
	/*   95 */ "d2",
	/*   96 */ "d3",
	/*   97 */ "d4",
	/*   98 */ "d6",
	/*   99 */ "d8",
	/*  100 */ "d10",
	/*  101 */ "d12",
	/*  102 */ "d20",
	/*  103 */ "d100",
	/*  104 */ "VectorMagnitude",
	/*  105 */ "GetMetaMagicFeat",
	/*  106 */ "GetObjectType",
	/*  107 */ "GetRacialType",
	/*  108 */ "FortitudeSave",
	/*  109 */ "ReflexSave",
	/*  110 */ "WillSave",
	/*  111 */ "GetSpellSaveDC",
	/*  112 */ "MagicalEffect",
	/*  113 */ "SupernaturalEffect",
	/*  114 */ "ExtraordinaryEffect",
	/*  115 */ "EffectACIncrease",
	/*  116 */ "GetAC",
	/*  117 */ "EffectSavingThrowIncrease",
	/*  118 */ "EffectAttackIncrease",
	/*  119 */ "EffectDamageReduction",
	/*  120 */ "EffectDamageIncrease",
	/*  121 */ "RoundsToSeconds",
	/*  122 */ "HoursToSeconds",
	/*  123 */ "TurnsToSeconds",
	/*  124 */ "GetLawChaosValue",
	/*  125 */ "GetGoodEvilValue",
	/*  126 */ "GetAlignmentLawChaos",
	/*  127 */ "GetAlignmentGoodEvil",
	/*  128 */ "GetFirstObjectInShape",
	/*  129 */ "GetNextObjectInShape",
	/*  130 */ "EffectEntangle",
	/*  131 */ "SignalEvent",
	/*  132 */ "EventUserDefined",
	/*  133 */ "EffectDeath",
	/*  134 */ "EffectKnockdown",
	/*  135 */ "ActionGiveItem",
	/*  136 */ "ActionTakeItem",
	/*  137 */ "VectorNormalize",
	/*  138 */ "EffectCurse",
	/*  139 */ "GetAbilityScore",
	/*  140 */ "GetIsDead",
	/*  141 */ "PrintVector",
	/*  142 */ "Vector",
	/*  143 */ "SetFacingPoint",
	/*  144 */ "AngleToVector",
	/*  145 */ "VectorToAngle",
	/*  146 */ "TouchAttackMelee",
	/*  147 */ "TouchAttackRanged",
	/*  148 */ "EffectParalyze",
	/*  149 */ "EffectSpellImmunity",
	/*  150 */ "EffectDeaf",
	/*  151 */ "GetDistanceBetween",
	/*  152 */ "SetLocalLocation",
	/*  153 */ "GetLocalLocation",
	/*  154 */ "EffectSleep",
	/*  155 */ "GetItemInSlot",
	/*  156 */ "EffectCharmed",
	/*  157 */ "EffectConfused",
	/*  158 */ "EffectFrightened",
	/*  159 */ "EffectDominated",
	/*  160 */ "EffectDazed",
	/*  161 */ "EffectStunned",
	/*  162 */ "SetCommandable",
	/*  163 */ "GetCommandable",
	/*  164 */ "EffectRegenerate",
	/*  165 */ "EffectMovementSpeedIncrease",
	/*  166 */ "GetHitDice",
	/*  167 */ "ActionForceFollowObject",
	/*  168 */ "GetTag",
	/*  169 */ "ResistSpell",
	/*  170 */ "GetEffectType",
	/*  171 */ "EffectAreaOfEffect",
	/*  172 */ "GetFactionEqual",
	/*  173 */ "ChangeFaction",
	/*  174 */ "GetIsListening",
	/*  175 */ "SetListening",
	/*  176 */ "SetListenPattern",
	/*  177 */ "TestStringAgainstPattern",
	/*  178 */ "GetMatchedSubstring",
	/*  179 */ "GetMatchedSubstringsCount",
	/*  180 */ "EffectVisualEffect",
	/*  181 */ "GetFactionWeakestMember",
	/*  182 */ "GetFactionStrongestMember",
	/*  183 */ "GetFactionMostDamagedMember",
	/*  184 */ "GetFactionLeastDamagedMember",
	/*  185 */ "GetFactionGold",
	/*  186 */ "GetFactionAverageReputation",
	/*  187 */ "GetFactionAverageGoodEvilAlignment",
	/*  188 */ "GetFactionAverageLawChaosAlignment",
	/*  189 */ "GetFactionAverageLevel",
	/*  190 */ "GetFactionAverageXP",
	/*  191 */ "GetFactionMostFrequentClass",
	/*  192 */ "GetFactionWorstAC",
	/*  193 */ "GetFactionBestAC",
	/*  194 */ "ActionSit",
	/*  195 */ "GetListenPatternNumber",
	/*  196 */ "ActionJumpToObject",
	/*  197 */ "GetWaypointByTag",
	/*  198 */ "GetTransitionTarget",
	/*  199 */ "EffectLinkEffects",
	/*  200 */ "GetObjectByTag",
	/*  201 */ "AdjustAlignment",
	/*  202 */ "ActionWait",
	/*  203 */ "SetAreaTransitionBMP",
	/*  204 */ "ActionStartConversation",
	/*  205 */ "ActionPauseConversation",
	/*  206 */ "ActionResumeConversation",
	/*  207 */ "EffectBeam",
	/*  208 */ "GetReputation",
	/*  209 */ "AdjustReputation",
	/*  210 */ "GetSittingCreature",
	/*  211 */ "GetGoingToBeAttackedBy",
	/*  212 */ "EffectSpellResistanceIncrease",
	/*  213 */ "GetLocation",
	/*  214 */ "ActionJumpToLocation",
	/*  215 */ "Location",
	/*  216 */ "ApplyEffectAtLocation",
	/*  217 */ "GetIsPC",
	/*  218 */ "FeetToMeters",
	/*  219 */ "YardsToMeters",
	/*  220 */ "ApplyEffectToObject",
	/*  221 */ "SpeakString",
	/*  222 */ "GetSpellTargetLocation",
	/*  223 */ "GetPositionFromLocation",
	/*  224 */ "GetAreaFromLocation",
	/*  225 */ "GetFacingFromLocation",
	/*  226 */ "GetNearestCreatureToLocation",
	/*  227 */ "GetNearestObject",
	/*  228 */ "GetNearestObjectToLocation",
	/*  229 */ "GetNearestObjectByTag",
	/*  230 */ "IntToFloat",
	/*  231 */ "FloatToInt",
	/*  232 */ "StringToInt",
	/*  233 */ "StringToFloat",
	/*  234 */ "ActionCastSpellAtLocation",
	/*  235 */ "GetIsEnemy",
	/*  236 */ "GetIsFriend",
	/*  237 */ "GetIsNeutral",
	/*  238 */ "GetPCSpeaker",
	/*  239 */ "GetStringByStrRef",
	/*  240 */ "ActionSpeakStringByStrRef",
	/*  241 */ "DestroyObject",
	/*  242 */ "GetModule",
	/*  243 */ "CreateObject",
	/*  244 */ "EventSpellCastAt",
	/*  245 */ "GetLastSpellCaster",
	/*  246 */ "GetLastSpell",
	/*  247 */ "GetUserDefinedEventNumber",
	/*  248 */ "GetSpellId",
	/*  249 */ "RandomName",
	/*  250 */ "EffectPoison",
	/*  251 */ "EffectDisease",
	/*  252 */ "EffectSilence",
	/*  253 */ "GetName",
	/*  254 */ "GetLastSpeaker",
	/*  255 */ "BeginConversation",
	/*  256 */ "GetLastPerceived",
	/*  257 */ "GetLastPerceptionHeard",
	/*  258 */ "GetLastPerceptionInaudible",
	/*  259 */ "GetLastPerceptionSeen",
	/*  260 */ "GetLastClosedBy",
	/*  261 */ "GetLastPerceptionVanished",
	/*  262 */ "GetFirstInPersistentObject",
	/*  263 */ "GetNextInPersistentObject",
	/*  264 */ "GetAreaOfEffectCreator",
	/*  265 */ "DeleteLocalInt",
	/*  266 */ "DeleteLocalFloat",
	/*  267 */ "DeleteLocalString",
	/*  268 */ "DeleteLocalObject",
	/*  269 */ "DeleteLocalLocation",
	/*  270 */ "EffectHaste",
	/*  271 */ "EffectSlow",
	/*  272 */ "ObjectToString",
	/*  273 */ "EffectImmunity",
	/*  274 */ "GetIsImmune",
	/*  275 */ "EffectDamageImmunityIncrease",
	/*  276 */ "GetEncounterActive",
	/*  277 */ "SetEncounterActive",
	/*  278 */ "GetEncounterSpawnsMax",
	/*  279 */ "SetEncounterSpawnsMax",
	/*  280 */ "GetEncounterSpawnsCurrent",
	/*  281 */ "SetEncounterSpawnsCurrent",
	/*  282 */ "GetModuleItemAcquired",
	/*  283 */ "GetModuleItemAcquiredFrom",
	/*  284 */ "SetCustomToken",
	/*  285 */ "GetHasFeat",
	/*  286 */ "GetHasSkill",
	/*  287 */ "ActionUseFeat",
	/*  288 */ "ActionUseSkill",
	/*  289 */ "GetObjectSeen",
	/*  290 */ "GetObjectHeard",
	/*  291 */ "GetLastPlayerDied",
	/*  292 */ "GetModuleItemLost",
	/*  293 */ "GetModuleItemLostBy",
	/*  294 */ "ActionDoCommand",
	/*  295 */ "EventConversation",
	/*  296 */ "SetEncounterDifficulty",
	/*  297 */ "GetEncounterDifficulty",
	/*  298 */ "GetDistanceBetweenLocations",
	/*  299 */ "GetReflexAdjustedDamage",
	/*  300 */ "PlayAnimation",
	/*  301 */ "TalentSpell",
	/*  302 */ "TalentFeat",
	/*  303 */ "TalentSkill",
	/*  304 */ "GetHasSpellEffect",
	/*  305 */ "GetEffectSpellId",
	/*  306 */ "GetCreatureHasTalent",
	/*  307 */ "GetCreatureTalentRandom",
	/*  308 */ "GetCreatureTalentBest",
	/*  309 */ "ActionUseTalentOnObject",
	/*  310 */ "ActionUseTalentAtLocation",
	/*  311 */ "GetGoldPieceValue",
	/*  312 */ "GetIsPlayableRacialType",
	/*  313 */ "JumpToLocation",
	/*  314 */ "EffectTemporaryHitpoints",
	/*  315 */ "GetSkillRank",
	/*  316 */ "GetAttackTarget",
	/*  317 */ "GetLastAttackType",
	/*  318 */ "GetLastAttackMode",
	/*  319 */ "GetMaster",
	/*  320 */ "GetIsInCombat",
	/*  321 */ "GetLastAssociateCommand",
	/*  322 */ "GiveGoldToCreature",
	/*  323 */ "SetIsDestroyable",
	/*  324 */ "SetLocked",
	/*  325 */ "GetLocked",
	/*  326 */ "GetClickingObject",
	/*  327 */ "SetAssociateListenPatterns",
	/*  328 */ "GetLastWeaponUsed",
	/*  329 */ "ActionInteractObject",
	/*  330 */ "GetLastUsedBy",
	/*  331 */ "GetAbilityModifier",
	/*  332 */ "GetIdentified",
	/*  333 */ "SetIdentified",
	/*  334 */ "SummonAnimalCompanion",
	/*  335 */ "SummonFamiliar",
	/*  336 */ "GetBlockingDoor",
	/*  337 */ "GetIsDoorActionPossible",
	/*  338 */ "DoDoorAction",
	/*  339 */ "GetFirstItemInInventory",
	/*  340 */ "GetNextItemInInventory",
	/*  341 */ "GetClassByPosition",
	/*  342 */ "GetLevelByPosition",
	/*  343 */ "GetLevelByClass",
	/*  344 */ "GetDamageDealtByType",
	/*  345 */ "GetTotalDamageDealt",
	/*  346 */ "GetLastDamager",
	/*  347 */ "GetLastDisarmed",
	/*  348 */ "GetLastDisturbed",
	/*  349 */ "GetLastLocked",
	/*  350 */ "GetLastUnlocked",
	/*  351 */ "EffectSkillIncrease",
	/*  352 */ "GetInventoryDisturbType",
	/*  353 */ "GetInventoryDisturbItem",
	/*  354 */ "GetHenchman",
	/*  355 */ "VersusAlignmentEffect",
	/*  356 */ "VersusRacialTypeEffect",
	/*  357 */ "VersusTrapEffect",
	/*  358 */ "GetGender",
	/*  359 */ "GetIsTalentValid",
	/*  360 */ "ActionMoveAwayFromLocation",
	/*  361 */ "GetAttemptedAttackTarget",
	/*  362 */ "GetTypeFromTalent",
	/*  363 */ "GetIdFromTalent",
	/*  364 */ "GetAssociate",
	/*  365 */ "AddHenchman",
	/*  366 */ "RemoveHenchman",
	/*  367 */ "AddJournalQuestEntry",
	/*  368 */ "RemoveJournalQuestEntry",
	/*  369 */ "GetPCPublicCDKey",
	/*  370 */ "GetPCIPAddress",
	/*  371 */ "GetPCPlayerName",
	/*  372 */ "SetPCLike",
	/*  373 */ "SetPCDislike",
	/*  374 */ "SendMessageToPC",
	/*  375 */ "GetAttemptedSpellTarget",
	/*  376 */ "GetLastOpenedBy",
	/*  377 */ "GetHasSpell",
	/*  378 */ "OpenStore",
	/*  379 */ "EffectTurned",
	/*  380 */ "GetFirstFactionMember",
	/*  381 */ "GetNextFactionMember",
	/*  382 */ "ActionForceMoveToLocation",
	/*  383 */ "ActionForceMoveToObject",
	/*  384 */ "GetJournalQuestExperience",
	/*  385 */ "JumpToObject",
	/*  386 */ "SetMapPinEnabled",
	/*  387 */ "EffectHitPointChangeWhenDying",
	/*  388 */ "PopUpGUIPanel",
	/*  389 */ "ClearPersonalReputation",
	/*  390 */ "SetIsTemporaryFriend",
	/*  391 */ "SetIsTemporaryEnemy",
	/*  392 */ "SetIsTemporaryNeutral",
	/*  393 */ "GiveXPToCreature",
	/*  394 */ "SetXP",
	/*  395 */ "GetXP",
	/*  396 */ "IntToHexString",
	/*  397 */ "GetBaseItemType",
	/*  398 */ "GetItemHasItemProperty",
	/*  399 */ "ActionEquipMostDamagingMelee",
	/*  400 */ "ActionEquipMostDamagingRanged",
	/*  401 */ "GetItemACValue",
	/*  402 */ "ActionRest",
	/*  403 */ "ExploreAreaForPlayer",
	/*  404 */ "ActionEquipMostEffectiveArmor",
	/*  405 */ "GetIsDay",
	/*  406 */ "GetIsNight",
	/*  407 */ "GetIsDawn",
	/*  408 */ "GetIsDusk",
	/*  409 */ "GetIsEncounterCreature",
	/*  410 */ "GetLastPlayerDying",
	/*  411 */ "GetStartingLocation",
	/*  412 */ "ChangeToStandardFaction",
	/*  413 */ "SoundObjectPlay",
	/*  414 */ "SoundObjectStop",
	/*  415 */ "SoundObjectSetVolume",
	/*  416 */ "SoundObjectSetPosition",
	/*  417 */ "SpeakOneLinerConversation",
	/*  418 */ "GetGold",
	/*  419 */ "GetLastRespawnButtonPresser",
	/*  420 */ "GetIsDM",
	/*  421 */ "PlayVoiceChat",
	/*  422 */ "GetIsWeaponEffective",
	/*  423 */ "GetLastSpellHarmful",
	/*  424 */ "EventActivateItem",
	/*  425 */ "MusicBackgroundPlay",
	/*  426 */ "MusicBackgroundStop",
	/*  427 */ "MusicBackgroundSetDelay",
	/*  428 */ "MusicBackgroundChangeDay",
	/*  429 */ "MusicBackgroundChangeNight",
	/*  430 */ "MusicBattlePlay",
	/*  431 */ "MusicBattleStop",
	/*  432 */ "MusicBattleChange",
	/*  433 */ "AmbientSoundPlay",
	/*  434 */ "AmbientSoundStop",
	/*  435 */ "AmbientSoundChangeDay",
	/*  436 */ "AmbientSoundChangeNight",
	/*  437 */ "GetLastKiller",
	/*  438 */ "GetSpellCastItem",
	/*  439 */ "GetItemActivated",
	/*  440 */ "GetItemActivator",
	/*  441 */ "GetItemActivatedTargetLocation",
	/*  442 */ "GetItemActivatedTarget",
	/*  443 */ "GetIsOpen",
	/*  444 */ "TakeGoldFromCreature",
	/*  445 */ "IsInConversation",
	/*  446 */ "EffectAbilityDecrease",
	/*  447 */ "EffectAttackDecrease",
	/*  448 */ "EffectDamageDecrease",
	/*  449 */ "EffectDamageImmunityDecrease",
	/*  450 */ "EffectACDecrease",
	/*  451 */ "EffectMovementSpeedDecrease",
	/*  452 */ "EffectSavingThrowDecrease",
	/*  453 */ "EffectSkillDecrease",
	/*  454 */ "EffectSpellResistanceDecrease",
	/*  455 */ "GetPlotFlag",
	/*  456 */ "SetPlotFlag",
	/*  457 */ "EffectInvisibility",
	/*  458 */ "EffectConcealment",
	/*  459 */ "EffectDarkness",
	/*  460 */ "EffectDispelMagicAll",
	/*  461 */ "EffectUltravision",
	/*  462 */ "EffectNegativeLevel",
	/*  463 */ "EffectPolymorph",
	/*  464 */ "EffectSanctuary",
	/*  465 */ "EffectTrueSeeing",
	/*  466 */ "EffectSeeInvisible",
	/*  467 */ "EffectTimeStop",
	/*  468 */ "EffectBlindness",
	/*  469 */ "GetIsReactionTypeFriendly",
	/*  470 */ "GetIsReactionTypeNeutral",
	/*  471 */ "GetIsReactionTypeHostile",
	/*  472 */ "EffectSpellLevelAbsorption",
	/*  473 */ "EffectDispelMagicBest",
	/*  474 */ "ActivatePortal",
	/*  475 */ "GetNumStackedItems",
	/*  476 */ "SurrenderToEnemies",
	/*  477 */ "EffectMissChance",
	/*  478 */ "GetTurnResistanceHD",
	/*  479 */ "GetCreatureSize",
	/*  480 */ "EffectDisappearAppear",
	/*  481 */ "EffectDisappear",
	/*  482 */ "EffectAppear",
	/*  483 */ "ActionUnlockObject",
	/*  484 */ "ActionLockObject",
	/*  485 */ "EffectModifyAttacks",
	/*  486 */ "GetLastTrapDetected",
	/*  487 */ "EffectDamageShield",
	/*  488 */ "GetNearestTrapToObject",
	/*  489 */ "GetDeity",
	/*  490 */ "GetSubRace",
	/*  491 */ "GetFortitudeSavingThrow",
	/*  492 */ "GetWillSavingThrow",
	/*  493 */ "GetReflexSavingThrow",
	/*  494 */ "GetChallengeRating",
	/*  495 */ "GetAge",
	/*  496 */ "GetMovementRate",
	/*  497 */ "GetAnimalCompanionCreatureType",
	/*  498 */ "GetFamiliarCreatureType",
	/*  499 */ "GetAnimalCompanionName",
	/*  500 */ "GetFamiliarName",
	/*  501 */ "ActionCastFakeSpellAtObject",
	/*  502 */ "ActionCastFakeSpellAtLocation",
	/*  503 */ "RemoveSummonedAssociate",
	/*  504 */ "SetCameraMode",
	/*  505 */ "GetIsResting",
	/*  506 */ "GetLastPCRested",
	/*  507 */ "SetWeather",
	/*  508 */ "GetLastRestEventType",
	/*  509 */ "StartNewModule",
	/*  510 */ "EffectSwarm",
	/*  511 */ "GetWeaponRanged",
	/*  512 */ "DoSinglePlayerAutoSave",
	/*  513 */ "GetGameDifficulty",
	/*  514 */ "SetTileMainLightColor",
	/*  515 */ "SetTileSourceLightColor",
	/*  516 */ "RecomputeStaticLighting",
	/*  517 */ "GetTileMainLight1Color",
	/*  518 */ "GetTileMainLight2Color",
	/*  519 */ "GetTileSourceLight1Color",
	/*  520 */ "GetTileSourceLight2Color",
	/*  521 */ "SetPanelButtonFlash",
	/*  522 */ "GetCurrentAction",
	/*  523 */ "SetStandardFactionReputation",
	/*  524 */ "GetStandardFactionReputation",
	/*  525 */ "FloatingTextStrRefOnCreature",
	/*  526 */ "FloatingTextStringOnCreature",
	/*  527 */ "GetTrapDisarmable",
	/*  528 */ "GetTrapDetectable",
	/*  529 */ "GetTrapDetectedBy",
	/*  530 */ "GetTrapFlagged",
	/*  531 */ "GetTrapBaseType",
	/*  532 */ "GetTrapOneShot",
	/*  533 */ "GetTrapCreator",
	/*  534 */ "GetTrapKeyTag",
	/*  535 */ "GetTrapDisarmDC",
	/*  536 */ "GetTrapDetectDC",
	/*  537 */ "GetLockKeyRequired",
	/*  538 */ "GetLockKeyTag",
	/*  539 */ "GetLockLockable",
	/*  540 */ "GetLockUnlockDC",
	/*  541 */ "GetLockLockDC",
	/*  542 */ "GetPCLevellingUp",
	/*  543 */ "GetHasFeatEffect",
	/*  544 */ "SetPlaceableIllumination",
	/*  545 */ "GetPlaceableIllumination",
	/*  546 */ "GetIsPlaceableObjectActionPossible",
	/*  547 */ "DoPlaceableObjectAction",
	/*  548 */ "GetFirstPC",
	/*  549 */ "GetNextPC",
	/*  550 */ "SetTrapDetectedBy",
	/*  551 */ "GetIsTrapped",
	/*  552 */ "EffectTurnResistanceDecrease",
	/*  553 */ "EffectTurnResistanceIncrease",
	/*  554 */ "PopUpDeathGUIPanel",
	/*  555 */ "SetTrapDisabled",
	/*  556 */ "GetLastHostileActor",
	/*  557 */ "ExportAllCharacters",
	/*  558 */ "MusicBackgroundGetDayTrack",
	/*  559 */ "MusicBackgroundGetNightTrack",
	/*  560 */ "WriteTimestampedLogEntry",
	/*  561 */ "GetModuleName",
	/*  562 */ "GetFactionLeader",
	/*  563 */ "SendMessageToAllDMs",
	/*  564 */ "EndGame",
	/*  565 */ "BootPC",
	/*  566 */ "ActionCounterSpell",
	/*  567 */ "AmbientSoundSetDayVolume",
	/*  568 */ "AmbientSoundSetNightVolume",
	/*  569 */ "MusicBackgroundGetBattleTrack",
	/*  570 */ "GetHasInventory",
	/*  571 */ "GetStrRefSoundDuration",
	/*  572 */ "AddToParty",
	/*  573 */ "RemoveFromParty",
	/*  574 */ "GetStealthMode",
	/*  575 */ "GetDetectMode",
	/*  576 */ "GetDefensiveCastingMode",
	/*  577 */ "GetAppearanceType",
	/*  578 */ "SpawnScriptDebugger",
	/*  579 */ "GetModuleItemAcquiredStackSize",
	/*  580 */ "DecrementRemainingFeatUses",
	/*  581 */ "DecrementRemainingSpellUses",
	/*  582 */ "GetResRef",
	/*  583 */ "EffectPetrify",
	/*  584 */ "CopyItem",
	/*  585 */ "EffectCutsceneParalyze",
	/*  586 */ "GetDroppableFlag",
	/*  587 */ "GetUseableFlag",
	/*  588 */ "GetStolenFlag",
	/*  589 */ "SetCampaignFloat",
	/*  590 */ "SetCampaignInt",
	/*  591 */ "SetCampaignVector",
	/*  592 */ "SetCampaignLocation",
	/*  593 */ "SetCampaignString",
	/*  594 */ "DestroyCampaignDatabase",
	/*  595 */ "GetCampaignFloat",
	/*  596 */ "GetCampaignInt",
	/*  597 */ "GetCampaignVector",
	/*  598 */ "GetCampaignLocation",
	/*  599 */ "GetCampaignString",
	/*  600 */ "CopyObject",
	/*  601 */ "DeleteCampaignVariable",
	/*  602 */ "StoreCampaignObject",
	/*  603 */ "RetrieveCampaignObject",
	/*  604 */ "EffectCutsceneDominated",
	/*  605 */ "GetItemStackSize",
	/*  606 */ "SetItemStackSize",
	/*  607 */ "GetItemCharges",
	/*  608 */ "SetItemCharges",
	/*  609 */ "AddItemProperty",
	/*  610 */ "RemoveItemProperty",
	/*  611 */ "GetIsItemPropertyValid",
	/*  612 */ "GetFirstItemProperty",
	/*  613 */ "GetNextItemProperty",
	/*  614 */ "GetItemPropertyType",
	/*  615 */ "GetItemPropertyDurationType",
	/*  616 */ "ItemPropertyAbilityBonus",
	/*  617 */ "ItemPropertyACBonus",
	/*  618 */ "ItemPropertyACBonusVsAlign",
	/*  619 */ "ItemPropertyACBonusVsDmgType",
	/*  620 */ "ItemPropertyACBonusVsRace",
	/*  621 */ "ItemPropertyACBonusVsSAlign",
	/*  622 */ "ItemPropertyEnhancementBonus",
	/*  623 */ "ItemPropertyEnhancementBonusVsAlign",
	/*  624 */ "ItemPropertyEnhancementBonusVsRace",
	/*  625 */ "ItemPropertyEnhancementBonusVsSAlign",
	/*  626 */ "ItemPropertyEnhancementPenalty",
	/*  627 */ "ItemPropertyWeightReduction",
	/*  628 */ "ItemPropertyBonusFeat",
	/*  629 */ "ItemPropertyBonusLevelSpell",
	/*  630 */ "ItemPropertyCastSpell",
	/*  631 */ "ItemPropertyDamageBonus",
	/*  632 */ "ItemPropertyDamageBonusVsAlign",
	/*  633 */ "ItemPropertyDamageBonusVsRace",
	/*  634 */ "ItemPropertyDamageBonusVsSAlign",
	/*  635 */ "ItemPropertyDamageImmunity",
	/*  636 */ "ItemPropertyDamagePenalty",
	/*  637 */ "ItemPropertyDamageReduction",
	/*  638 */ "ItemPropertyDamageResistance",
	/*  639 */ "ItemPropertyDamageVulnerability",
	/*  640 */ "ItemPropertyDarkvision",
	/*  641 */ "ItemPropertyDecreaseAbility",
	/*  642 */ "ItemPropertyDecreaseAC",
	/*  643 */ "ItemPropertyDecreaseSkill",
	/*  644 */ "ItemPropertyContainerReducedWeight",
	/*  645 */ "ItemPropertyExtraMeleeDamageType",
	/*  646 */ "ItemPropertyExtraRangeDamageType",
	/*  647 */ "ItemPropertyHaste",
	/*  648 */ "ItemPropertyHolyAvenger",
	/*  649 */ "ItemPropertyImmunityMisc",
	/*  650 */ "ItemPropertyImprovedEvasion",
	/*  651 */ "ItemPropertyBonusSpellResistance",
	/*  652 */ "ItemPropertyBonusSavingThrowVsX",
	/*  653 */ "ItemPropertyBonusSavingThrow",
	/*  654 */ "ItemPropertyKeen",
	/*  655 */ "ItemPropertyLight",
	/*  656 */ "ItemPropertyMaxRangeStrengthMod",
	/*  657 */ "ItemPropertyNoDamage",
	/*  658 */ "ItemPropertyOnHitProps",
	/*  659 */ "ItemPropertyReducedSavingThrowVsX",
	/*  660 */ "ItemPropertyReducedSavingThrow",
	/*  661 */ "ItemPropertyRegeneration",
	/*  662 */ "ItemPropertySkillBonus",
	/*  663 */ "ItemPropertySpellImmunitySpecific",
	/*  664 */ "ItemPropertySpellImmunitySchool",
	/*  665 */ "ItemPropertyThievesTools",
	/*  666 */ "ItemPropertyAttackBonus",
	/*  667 */ "ItemPropertyAttackBonusVsAlign",
	/*  668 */ "ItemPropertyAttackBonusVsRace",
	/*  669 */ "ItemPropertyAttackBonusVsSAlign",
	/*  670 */ "ItemPropertyAttackPenalty",
	/*  671 */ "ItemPropertyUnlimitedAmmo",
	/*  672 */ "ItemPropertyLimitUseByAlign",
	/*  673 */ "ItemPropertyLimitUseByClass",
	/*  674 */ "ItemPropertyLimitUseByRace",
	/*  675 */ "ItemPropertyLimitUseBySAlign",
	/*  676 */ "ItemPropertyBonusHitpoints",
	/*  677 */ "ItemPropertyVampiricRegeneration",
	/*  678 */ "ItemPropertyTrap",
	/*  679 */ "ItemPropertyTrueSeeing",
	/*  680 */ "ItemPropertyOnMonsterHitProperties",
	/*  681 */ "ItemPropertyTurnResistance",
	/*  682 */ "ItemPropertyMassiveCritical",
	/*  683 */ "ItemPropertyFreeAction",
	/*  684 */ "ItemPropertyMonsterDamage",
	/*  685 */ "ItemPropertyImmunityToSpellLevel",
	/*  686 */ "ItemPropertySpecialWalk",
	/*  687 */ "ItemPropertyHealersKit",
	/*  688 */ "ItemPropertyWeightIncrease",
	/*  689 */ "GetIsSkillSuccessful",
	/*  690 */ "EffectSpellFailure",
	/*  691 */ "SpeakStringByStrRef",
	/*  692 */ "SetCutsceneMode",
	/*  693 */ "GetLastPCToCancelCutscene",
	/*  694 */ "GetDialogSoundLength",
	/*  695 */ "FadeFromBlack",
	/*  696 */ "FadeToBlack",
	/*  697 */ "StopFade",
	/*  698 */ "BlackScreen",
	/*  699 */ "GetBaseAttackBonus",
	/*  700 */ "SetImmortal",
	/*  701 */ "OpenInventory",
	/*  702 */ "StoreCameraFacing",
	/*  703 */ "RestoreCameraFacing",
	/*  704 */ "LevelUpHenchman",
	/*  705 */ "SetDroppableFlag",
	/*  706 */ "GetWeight",
	/*  707 */ "GetModuleItemAcquiredBy",
	/*  708 */ "GetImmortal",
	/*  709 */ "DoWhirlwindAttack",
	/*  710 */ "Get2DAString",
	/*  711 */ "EffectEthereal",
	/*  712 */ "GetAILevel",
	/*  713 */ "SetAILevel",
	/*  714 */ "GetIsPossessedFamiliar",
	/*  715 */ "UnpossessFamiliar",
	/*  716 */ "GetIsAreaInterior",
	/*  717 */ "SendMessageToPCByStrRef",
	/*  718 */ "IncrementRemainingFeatUses",
	/*  719 */ "ExportSingleCharacter",
	/*  720 */ "PlaySoundByStrRef",
	/*  721 */ "SetSubRace",
	/*  722 */ "SetDeity",
	/*  723 */ "GetIsDMPossessed",
	/*  724 */ "GetWeather",
	/*  725 */ "GetIsAreaNatural",
	/*  726 */ "GetIsAreaAboveGround",
	/*  727 */ "GetPCItemLastEquipped",
	/*  728 */ "GetPCItemLastEquippedBy",
	/*  729 */ "GetPCItemLastUnequipped",
	/*  730 */ "GetPCItemLastUnequippedBy",
	/*  731 */ "CopyItemAndModify",
	/*  732 */ "GetItemAppearance",
	/*  733 */ "ItemPropertyOnHitCastSpell",
	/*  734 */ "GetItemPropertySubType",
	/*  735 */ "GetActionMode",
	/*  736 */ "SetActionMode",
	/*  737 */ "GetArcaneSpellFailure",
	/*  738 */ "ActionExamine",
	/*  739 */ "ItemPropertyVisualEffect",
	/*  740 */ "SetLootable",
	/*  741 */ "GetLootable",
	/*  742 */ "GetCutsceneCameraMoveRate",
	/*  743 */ "SetCutsceneCameraMoveRate",
	/*  744 */ "GetItemCursedFlag",
	/*  745 */ "SetItemCursedFlag",
	/*  746 */ "SetMaxHenchmen",
	/*  747 */ "GetMaxHenchmen",
	/*  748 */ "GetAssociateType",
	/*  749 */ "GetSpellResistance",
	/*  750 */ "DayToNight",
	/*  751 */ "NightToDay",
	/*  752 */ "LineOfSightObject",
	/*  753 */ "LineOfSightVector",
	/*  754 */ "GetLastSpellCastClass",
	/*  755 */ "SetBaseAttackBonus",
	/*  756 */ "RestoreBaseAttackBonus",
	/*  757 */ "EffectCutsceneGhost",
	/*  758 */ "ItemPropertyArcaneSpellFailure",
	/*  759 */ "GetStoreGold",
	/*  760 */ "SetStoreGold",
	/*  761 */ "GetStoreMaxBuyPrice",
	/*  762 */ "SetStoreMaxBuyPrice",
	/*  763 */ "GetStoreIdentifyCost",
	/*  764 */ "SetStoreIdentifyCost",
	/*  765 */ "SetCreatureAppearanceType",
	/*  766 */ "GetCreatureStartingPackage",
	/*  767 */ "EffectCutsceneImmobilize",
	/*  768 */ "GetIsInSubArea",
	/*  769 */ "GetItemPropertyCostTable",
	/*  770 */ "GetItemPropertyCostTableValue",
	/*  771 */ "GetItemPropertyParam1",
	/*  772 */ "GetItemPropertyParam1Value",
	/*  773 */ "GetIsCreatureDisarmable",
	/*  774 */ "SetStolenFlag",
	/*  775 */ "ForceRest",
	/*  776 */ "SetCameraHeight",
	/*  777 */ "SetGlobalInt",
	/*  778 */ "SetGlobalBool",
	/*  779 */ "SetGlobalString",
	/*  780 */ "SetGlobalFloat",
	/*  781 */ "GetGlobalInt",
	/*  782 */ "GetGlobalBool",
	/*  783 */ "GetGlobalString",
	/*  784 */ "GetGlobalFloat",
	/*  785 */ "SaveGlobalVariables",
	/*  786 */ "LoadGlobalVariables",
	/*  787 */ "MountObject",
	/*  788 */ "DismountObject",
	/*  789 */ "GetJournalEntry",
	/*  790 */ "EffectNWN2ParticleEffect",
	/*  791 */ "EffectNWN2ParticleEffectFile",
	/*  792 */ "EffectNWN2SpecialEffectFile",
	/*  793 */ "GetSpellLevel",
	/*  794 */ "RemoveSEFFromObject",
	/*  795 */ "ActionPauseCutscene",
	/*  796 */ "AssignCutsceneActionToObject",
	/*  797 */ "GetCharBackground",
	/*  798 */ "SetTrapActive",
	/*  799 */ "SetOrientOnDialog",
	/*  800 */ "EffectDetectUndead",
	/*  801 */ "EffectLowLightVision",
	/*  802 */ "EffectSetScale",
	/*  803 */ "EffectShareDamage",
	/*  804 */ "EffectAssayResistance",
	/*  805 */ "EffectSeeTrueHPs",
	/*  806 */ "GetNumCutsceneActionsPending",
	/*  807 */ "EffectDamageOverTime",
	/*  808 */ "EffectAbsorbDamage",
	/*  809 */ "EffectHideousBlow",
	/*  810 */ "EffectMesmerize",
	/*  811 */ "GetSpellFeatId",
	/*  812 */ "SetFog",
	/*  813 */ "EffectDarkVision",
	/*  814 */ "DebugPostString",
	/*  815 */ "GetHasAnySpellEffect",
	/*  816 */ "EffectArmorCheckPenaltyIncrease",
	/*  817 */ "EffectDisintegrate",
	/*  818 */ "EffectHealOnZeroHP",
	/*  819 */ "EffectBreakEnchantment",
	/*  820 */ "GetFirstEnteringPC",
	/*  821 */ "GetNextEnteringPC",
	/*  822 */ "AddRosterMemberByTemplate",
	/*  823 */ "AddRosterMemberByCharacter",
	/*  824 */ "RemoveRosterMember",
	/*  825 */ "GetIsRosterMemberAvailable",
	/*  826 */ "GetIsRosterMemberSelectable",
	/*  827 */ "SetIsRosterMemberSelectable",
	/*  828 */ "GetObjectFromRosterName",
	/*  829 */ "GetRosterNameFromObject",
	/*  830 */ "SpawnRosterMember",
	/*  831 */ "DespawnRosterMember",
	/*  832 */ "AddRosterMemberToParty",
	/*  833 */ "RemoveRosterMemberFromParty",
	/*  834 */ "GetFirstRosterMember",
	/*  835 */ "GetNextRosterMember",
	/*  836 */ "SpawnSpellProjectile",
	/*  837 */ "SpawnItemProjectile",
	/*  838 */ "GetIsOwnedByPlayer",
	/*  839 */ "SetOwnersControlledCompanion",
	/*  840 */ "SetCreatureScriptsToSet",
	/*  841 */ "GetProjectileTravelTime",
	/*  842 */ "SetRosterNPCPartyLimit",
	/*  843 */ "GetRosterNPCPartyLimit",
	/*  844 */ "SetIsRosterMemberCampaignNPC",
	/*  845 */ "GetIsRosterMemberCampaignNPC",
	/*  846 */ "GetIsRosterMember",
	/*  847 */ "ShowWorldMap",
	/*  848 */ "TriggerEncounter",
	/*  849 */ "GetIsSinglePlayer",
	/*  850 */ "DisplayGuiScreen",
	/*  851 */ "EffectOnDispel",
	/*  852 */ "LoadNewModule",
	/*  853 */ "SetScriptHidden",
	/*  854 */ "SetIsCompanionPossessionBlocked",
	/*  855 */ "SetEventHandler",
	/*  856 */ "GetEventHandler",
	/*  857 */ "GetIsPartyTransition",
	/*  858 */ "JumpPartyToArea",
	/*  859 */ "GetNumActions",
	/*  860 */ "DisplayMessageBox",
	/*  861 */ "StringCompare",
	/*  862 */ "CharToASCII",
	/*  863 */ "GetOwnedCharacter",
	/*  864 */ "GetControlledCharacter",
	/*  865 */ "FeatAdd",
	/*  866 */ "FeatRemove",
	/*  867 */ "SetCanTalkToNonPlayerOwnedCreatures",
	/*  868 */ "GetCanTalkToNonPlayerOwnedCreatures",
	/*  869 */ "SetLevelUpPackage",
	/*  870 */ "GetLevelUpPackage",
	/*  871 */ "SetCombatOverrides",
	/*  872 */ "ClearCombatOverrides",
	/*  873 */ "ResetCreatureLevelForXP",
	/*  874 */ "CalcPointAwayFromPoint",
	/*  875 */ "CalcSafeLocation",
	/*  876 */ "GetTotalLevels",
	/*  877 */ "ResetFeatUses",
	/*  878 */ "SetNWN2Fog",
	/*  879 */ "ResetNWN2Fog",
	/*  880 */ "EffectBonusHitpoints",
	/*  881 */ "SetGUIObjectHidden",
	/*  882 */ "CloseGUIScreen",
	/*  883 */ "FiredFromPartyTransition",
	/*  884 */ "GetScriptHidden",
	/*  885 */ "GetNodeSpeaker",
	/*  886 */ "SetLocalGUIVariable",
	/*  887 */ "SetGUIObjectDisabled",
	/*  888 */ "SetGUIObjectText",
	/*  889 */ "GetIsCompanionPossessionBlocked",
	/*  890 */ "EffectBardSongSinging",
	/*  891 */ "EffectJarring",
	/*  892 */ "GetEffectInteger",
	/*  893 */ "RefreshSpellEffectDurations",
	/*  894 */ "SetEffectSpellId",
	/*  895 */ "EffectBABMinimum",
	/*  896 */ "GetTRUEBaseAttackBonus",
	/*  897 */ "SetFirstName",
	/*  898 */ "SetLastName",
	/*  899 */ "SetDescription",
	/*  900 */ "GetFirstName",
	/*  901 */ "GetLastName",
	/*  902 */ "GetDescription",
	/*  903 */ "IsInMultiplayerConversation",
	/*  904 */ "PlayCustomAnimation",
	/*  905 */ "EffectMaxDamage",
	/*  906 */ "DisplayInputBox",
	/*  907 */ "SetWeaponVisibility",
	/*  908 */ "SetLookAtTarget",
	/*  909 */ "GetBumpState",
	/*  910 */ "SetBumpState",
	/*  911 */ "GetOnePartyMode",
	/*  912 */ "GetPrimaryPlayer",
	/*  913 */ "EffectArcaneSpellFailure",
	/*  914 */ "SpawnBloodHit",
	/*  915 */ "GetFirstArea",
	/*  916 */ "GetNextArea",
	/*  917 */ "GetArmorRank",
	/*  918 */ "GetWeaponType",
	/*  919 */ "GetPlayerCurrentTarget",
	/*  920 */ "EffectWildshape",
	/*  921 */ "GetEncumbranceState",
	/*  922 */ "PackCampaignDatabase",
	/*  923 */ "UnlinkDoor",
	/*  924 */ "GetPlayerCreatureExamineTarget",
	/*  925 */ "Clear2DACache",
	/*  926 */ "NWNXGetInt",
	/*  927 */ "NWNXGetFloat",
	/*  928 */ "NWNXGetString",
	/*  929 */ "NWNXSetInt",
	/*  930 */ "NWNXSetFloat",
	/*  931 */ "NWNXSetString",
	/*  932 */ "EffectEffectIcon",
	/*  933 */ "SetGUIProgressBarPosition",
	/*  934 */ "SetGUITexture",
	/*  935 */ "EffectRescue",
	/*  936 */ "IntToObject",
	/*  937 */ "ObjectToInt",
	/*  938 */ "StringToObject",
	/*  939 */ "GetIsSpirit",
	/*  940 */ "EffectDetectSpirits",
	/*  941 */ "EffectDamageReductionNegated",
	/*  942 */ "EffectConcealmentNegated",
	/*  943 */ "GetInfiniteFlag",
	/*  944 */ "GetKeyRequiredFeedbackMessage",
	/*  945 */ "SetKeyRequiredFeedbackMessage",
	/*  946 */ "SetInfiniteFlag",
	/*  947 */ "GetPickpocketableFlag",
	/*  948 */ "SetPickpocketableFlag",
	/*  949 */ "GetTrapActive",
	/*  950 */ "SetWillSavingThrow",
	/*  951 */ "SetReflexSavingThrow",
	/*  952 */ "SetFortitudeSavingThrow",
	/*  953 */ "SetLockKeyRequired",
	/*  954 */ "SetLockKeyTag",
	/*  955 */ "SetLockLockDC",
	/*  956 */ "SetLockUnlockDC",
	/*  957 */ "SetLockLockable",
	/*  958 */ "SetHardness",
	/*  959 */ "GetHardness",
	/*  960 */ "GetModuleXPScale",
	/*  961 */ "SetModuleXPScale",
	/*  962 */ "SetTrapDetectable",
	/*  963 */ "SetTrapDetectDC",
	/*  964 */ "SetTrapDisarmable",
	/*  965 */ "SetTrapDisarmDC",
	/*  966 */ "SetTrapKeyTag",
	/*  967 */ "SetTrapOneShot",
	/*  968 */ "CreateTrapAtLocation",
	/*  969 */ "CreateTrapOnObject",
	/*  970 */ "GetAreaSize",
	/*  971 */ "GetTrapRecoverable",
	/*  972 */ "SetTrapRecoverable",
	/*  973 */ "SetUseableFlag",
	/*  974 */ "GetPlaceableLastClickedBy",
	/*  975 */ "SetRenderWaterInArea",
	/*  976 */ "EffectInsane",
	/*  977 */ "SetPlayerGUIHidden",
	/*  978 */ "GetSelectedMapPointTag",
	/*  979 */ "SetNoticeText",
	/*  980 */ "SetLightActive",
	/*  981 */ "EffectSummonCopy",
	/*  982 */ "GetPolymorphLocked",
	/*  983 */ "SetSoundSet",
	/*  984 */ "SetScale",
	/*  985 */ "GetScale",
	/*  986 */ "GetNum2DARows",
	/*  987 */ "GetNum2DAColumns",
	/*  988 */ "SetCustomHeartbeat",
	/*  989 */ "GetCustomHeartbeat",
	/*  990 */ "SetScrollBarRanges",
	/*  991 */ "ClearListBox",
	/*  992 */ "AddListBoxRow",
	/*  993 */ "RemoveListBoxRow",
	/*  994 */ "GetItemPropActivation",
	/*  995 */ "SetItemPropActivation",
	/*  996 */ "ModifyListBoxRow",
	/*  997 */ "SetFactionLeader",
	/*  998 */ "GetFirstSubArea",
	/*  999 */ "GetNextSubArea",
	/* 1000 */ "GetMovementRateFactor",
	/* 1001 */ "SetMovementRateFactor",
	/* 1002 */ "GetBicFileName",
	/* 1003 */ "GetCollision",
	/* 1004 */ "SetCollision",
	/* 1005 */ "GetItemIcon",
	/* 1006 */ "GetVariableName",
	/* 1007 */ "GetVariableType",
	/* 1008 */ "GetAreaOfEffectDuration",
	/* 1009 */ "GetIsPlayerCreated",
	/* 1010 */ "GetPartyName",
	/* 1011 */ "GetPartyMotto",
	/* 1012 */ "GetIsOverlandMap",
	/* 1013 */ "SetUnrestrictedLevelUp",
	/* 1014 */ "GetSoundFileDuration",
	/* 1015 */ "GetPartyMembersDyingFlag",
	/* 1016 */ "SetListBoxRowSelected",
	/* 1017 */ "GetTalkTableLanguage",
	/* 1018 */ "SetScrollBarValue",
	/* 1019 */ "SetPause",
	/* 1020 */ "GetPause",
	/* 1021 */ "GetAreaOfEffectSpellId",
	/* 1022 */ "SetGlobalGUIVariable",
	/* 1023 */ "CreateInstancedAreaFromSource",
	/* 1024 */ "GetVariableValueInt",
	/* 1025 */ "GetVariableValueString",
	/* 1026 */ "GetVariableValueFloat",
	/* 1027 */ "GetVariableValueLocation",
	/* 1028 */ "GetVariableValueObject",
	/* 1029 */ "GetVariableCount",
	/* 1030 */ "SetBaseAbilityScore",
	/* 1031 */ "SetBaseSkillRank",
	/* 1032 */ "SendChatMessage",
	/* 1033 */ "GetIsLocationValid",
	/* 1034 */ "GetSurfaceMaterialsAtLocation",
	/* 1035 */ "GetSpellKnown",
	/* 1036 */ "GetItemBaseMaterialType",
	/* 1037 */ "SetItemBaseMaterialType",
	/* 1038 */ "SetSpellKnown",
	/* 1039 */ "GetLimboCreatureCount",
	/* 1040 */ "GetCreatureInLimbo",
	/* 1041 */ "SendCreatureToLimbo",
	/* 1042 */ "AddScriptParameterInt",
	/* 1043 */ "AddScriptParameterString",
	/* 1044 */ "AddScriptParameterFloat",
	/* 1045 */ "AddScriptParameterObject",
	/* 1046 */ "ExecuteScriptEnhanced",
	/* 1047 */ "ClearScriptParams",
	/* 1048 */ "SetSkillPointsRemaining",
	/* 1049 */ "GetSkillPointsRemaining",
	/* 1050 */ "GetCasterClassSpellSchool",
	/* 1051 */ "SetGender",
	/* 1052 */ "SetTag",
	/* 1053 */ "GetArmorRulesType",
	/* 1054 */ "SetArmorRulesType",
	/* 1055 */ "SetItemIcon",
	/* 1056 */ "GetObjectByTagAndType",
	/* 1057 */ "RecallCreatureFromLimboToLocation"
};

static const VariableType kFunctionSignatures[][GameInfo::kMaxSignatureSize] = {
	/*    0 */ { kTypeInt, kTypeInt },
	/*    1 */ { kTypeVoid, kTypeString },
	/*    2 */ { kTypeVoid, kTypeFloat, kTypeInt, kTypeInt },
	/*    3 */ { kTypeString, kTypeFloat, kTypeInt, kTypeInt },
	/*    4 */ { kTypeVoid, kTypeInt },
	/*    5 */ { kTypeVoid, kTypeObject },
	/*    6 */ { kTypeVoid, kTypeObject, kTypeScriptState },
	/*    7 */ { kTypeVoid, kTypeFloat, kTypeScriptState },
	/*    8 */ { kTypeVoid, kTypeString, kTypeObject },
	/*    9 */ { kTypeVoid, kTypeInt },
	/*   10 */ { kTypeVoid, kTypeFloat, kTypeInt },
	/*   11 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeInt },
	/*   12 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*   13 */ { kTypeInt },
	/*   14 */ { kTypeInt },
	/*   15 */ { kTypeInt },
	/*   16 */ { kTypeInt },
	/*   17 */ { kTypeInt },
	/*   18 */ { kTypeInt },
	/*   19 */ { kTypeInt },
	/*   20 */ { kTypeVoid },
	/*   21 */ { kTypeVoid, kTypeEngineType2, kTypeInt },
	/*   22 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/*   23 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/*   24 */ { kTypeObject, kTypeObject },
	/*   25 */ { kTypeObject },
	/*   26 */ { kTypeObject },
	/*   27 */ { kTypeVector, kTypeObject },
	/*   28 */ { kTypeFloat, kTypeObject },
	/*   29 */ { kTypeObject, kTypeObject },
	/*   30 */ { kTypeObject, kTypeObject, kTypeString },
	/*   31 */ { kTypeObject, kTypeString, kTypeObject, kTypeInt, kTypeString, kTypeInt },
	/*   32 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*   33 */ { kTypeVoid, kTypeObject },
	/*   34 */ { kTypeVoid, kTypeObject },
	/*   35 */ { kTypeVoid, kTypeObject },
	/*   36 */ { kTypeObject, kTypeObject },
	/*   37 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*   38 */ { kTypeObject, kTypeInt, kTypeInt, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*   39 */ { kTypeVoid, kTypeString, kTypeInt },
	/*   40 */ { kTypeVoid, kTypeInt, kTypeFloat, kTypeFloat },
	/*   41 */ { kTypeFloat, kTypeObject },
	/*   42 */ { kTypeInt, kTypeObject },
	/*   43 */ { kTypeVoid, kTypeObject },
	/*   44 */ { kTypeVoid, kTypeObject },
	/*   45 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeFloat, kTypeInt },
	/*   46 */ { kTypeVoid, kTypeString, kTypeInt },
	/*   47 */ { kTypeObject },
	/*   48 */ { kTypeVoid, kTypeInt, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*   49 */ { kTypeInt, kTypeObject },
	/*   50 */ { kTypeInt, kTypeObject },
	/*   51 */ { kTypeInt, kTypeObject, kTypeString },
	/*   52 */ { kTypeFloat, kTypeObject, kTypeString },
	/*   53 */ { kTypeString, kTypeObject, kTypeString },
	/*   54 */ { kTypeObject, kTypeObject, kTypeString },
	/*   55 */ { kTypeVoid, kTypeObject, kTypeString, kTypeInt },
	/*   56 */ { kTypeVoid, kTypeObject, kTypeString, kTypeFloat },
	/*   57 */ { kTypeVoid, kTypeObject, kTypeString, kTypeString },
	/*   58 */ { kTypeVoid, kTypeObject, kTypeString, kTypeObject },
	/*   59 */ { kTypeInt, kTypeString },
	/*   60 */ { kTypeString, kTypeString },
	/*   61 */ { kTypeString, kTypeString },
	/*   62 */ { kTypeString, kTypeString, kTypeInt },
	/*   63 */ { kTypeString, kTypeString, kTypeInt },
	/*   64 */ { kTypeString, kTypeString, kTypeString, kTypeInt },
	/*   65 */ { kTypeString, kTypeString, kTypeInt, kTypeInt },
	/*   66 */ { kTypeInt, kTypeString, kTypeString, kTypeInt },
	/*   67 */ { kTypeFloat, kTypeFloat },
	/*   68 */ { kTypeFloat, kTypeFloat },
	/*   69 */ { kTypeFloat, kTypeFloat },
	/*   70 */ { kTypeFloat, kTypeFloat },
	/*   71 */ { kTypeFloat, kTypeFloat },
	/*   72 */ { kTypeFloat, kTypeFloat },
	/*   73 */ { kTypeFloat, kTypeFloat },
	/*   74 */ { kTypeFloat, kTypeFloat },
	/*   75 */ { kTypeFloat, kTypeFloat, kTypeFloat },
	/*   76 */ { kTypeFloat, kTypeFloat },
	/*   77 */ { kTypeInt, kTypeInt },
	/*   78 */ { kTypeEngineType0, kTypeInt },
	/*   79 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*   80 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*   81 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/*   82 */ { kTypeEngineType0 },
	/*   83 */ { kTypeEngineType0, kTypeString, kTypeInt, kTypeFloat, kTypeInt },
	/*   84 */ { kTypeInt, kTypeObject },
	/*   85 */ { kTypeEngineType0, kTypeObject },
	/*   86 */ { kTypeEngineType0, kTypeObject },
	/*   87 */ { kTypeVoid, kTypeObject, kTypeEngineType0 },
	/*   88 */ { kTypeInt, kTypeEngineType0 },
	/*   89 */ { kTypeInt, kTypeEngineType0 },
	/*   90 */ { kTypeInt, kTypeEngineType0 },
	/*   91 */ { kTypeObject, kTypeEngineType0 },
	/*   92 */ { kTypeString, kTypeInt },
	/*   93 */ { kTypeObject, kTypeObject },
	/*   94 */ { kTypeObject, kTypeObject },
	/*   95 */ { kTypeInt, kTypeInt },
	/*   96 */ { kTypeInt, kTypeInt },
	/*   97 */ { kTypeInt, kTypeInt },
	/*   98 */ { kTypeInt, kTypeInt },
	/*   99 */ { kTypeInt, kTypeInt },
	/*  100 */ { kTypeInt, kTypeInt },
	/*  101 */ { kTypeInt, kTypeInt },
	/*  102 */ { kTypeInt, kTypeInt },
	/*  103 */ { kTypeInt, kTypeInt },
	/*  104 */ { kTypeFloat, kTypeVector },
	/*  105 */ { kTypeInt },
	/*  106 */ { kTypeInt, kTypeObject },
	/*  107 */ { kTypeInt, kTypeObject },
	/*  108 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt, kTypeObject },
	/*  109 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt, kTypeObject },
	/*  110 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt, kTypeObject },
	/*  111 */ { kTypeInt },
	/*  112 */ { kTypeEngineType0, kTypeEngineType0 },
	/*  113 */ { kTypeEngineType0, kTypeEngineType0 },
	/*  114 */ { kTypeEngineType0, kTypeEngineType0 },
	/*  115 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  116 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  117 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  118 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*  119 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  120 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/*  121 */ { kTypeFloat, kTypeInt },
	/*  122 */ { kTypeFloat, kTypeInt },
	/*  123 */ { kTypeFloat, kTypeInt },
	/*  124 */ { kTypeInt, kTypeObject },
	/*  125 */ { kTypeInt, kTypeObject },
	/*  126 */ { kTypeInt, kTypeObject },
	/*  127 */ { kTypeInt, kTypeObject },
	/*  128 */ { kTypeObject, kTypeInt, kTypeFloat, kTypeEngineType2, kTypeInt, kTypeInt, kTypeVector },
	/*  129 */ { kTypeObject, kTypeInt, kTypeFloat, kTypeEngineType2, kTypeInt, kTypeInt, kTypeVector },
	/*  130 */ { kTypeEngineType0 },
	/*  131 */ { kTypeVoid, kTypeObject, kTypeEngineType1 },
	/*  132 */ { kTypeEngineType1, kTypeInt },
	/*  133 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  134 */ { kTypeEngineType0 },
	/*  135 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt },
	/*  136 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt },
	/*  137 */ { kTypeVector, kTypeVector },
	/*  138 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  139 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt },
	/*  140 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  141 */ { kTypeVoid, kTypeVector, kTypeInt },
	/*  142 */ { kTypeVector, kTypeFloat, kTypeFloat, kTypeFloat },
	/*  143 */ { kTypeVoid, kTypeVector, kTypeInt },
	/*  144 */ { kTypeVector, kTypeFloat },
	/*  145 */ { kTypeFloat, kTypeVector },
	/*  146 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt },
	/*  147 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt },
	/*  148 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/*  149 */ { kTypeEngineType0, kTypeInt },
	/*  150 */ { kTypeEngineType0 },
	/*  151 */ { kTypeFloat, kTypeObject, kTypeObject },
	/*  152 */ { kTypeVoid, kTypeObject, kTypeString, kTypeEngineType2 },
	/*  153 */ { kTypeEngineType2, kTypeObject, kTypeString },
	/*  154 */ { kTypeEngineType0 },
	/*  155 */ { kTypeObject, kTypeInt, kTypeObject },
	/*  156 */ { kTypeEngineType0 },
	/*  157 */ { kTypeEngineType0 },
	/*  158 */ { kTypeEngineType0 },
	/*  159 */ { kTypeEngineType0 },
	/*  160 */ { kTypeEngineType0 },
	/*  161 */ { kTypeEngineType0 },
	/*  162 */ { kTypeVoid, kTypeInt, kTypeObject },
	/*  163 */ { kTypeInt, kTypeObject },
	/*  164 */ { kTypeEngineType0, kTypeInt, kTypeFloat },
	/*  165 */ { kTypeEngineType0, kTypeInt },
	/*  166 */ { kTypeInt, kTypeObject },
	/*  167 */ { kTypeVoid, kTypeObject, kTypeFloat, kTypeInt },
	/*  168 */ { kTypeString, kTypeObject },
	/*  169 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  170 */ { kTypeInt, kTypeEngineType0 },
	/*  171 */ { kTypeEngineType0, kTypeInt, kTypeString, kTypeString, kTypeString, kTypeString },
	/*  172 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  173 */ { kTypeVoid, kTypeObject, kTypeObject },
	/*  174 */ { kTypeInt, kTypeObject },
	/*  175 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  176 */ { kTypeVoid, kTypeObject, kTypeString, kTypeInt },
	/*  177 */ { kTypeInt, kTypeString, kTypeString },
	/*  178 */ { kTypeString, kTypeInt },
	/*  179 */ { kTypeInt },
	/*  180 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*  181 */ { kTypeObject, kTypeObject, kTypeInt },
	/*  182 */ { kTypeObject, kTypeObject, kTypeInt },
	/*  183 */ { kTypeObject, kTypeObject, kTypeInt },
	/*  184 */ { kTypeObject, kTypeObject, kTypeInt },
	/*  185 */ { kTypeInt, kTypeObject },
	/*  186 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  187 */ { kTypeInt, kTypeObject },
	/*  188 */ { kTypeInt, kTypeObject },
	/*  189 */ { kTypeInt, kTypeObject },
	/*  190 */ { kTypeInt, kTypeObject },
	/*  191 */ { kTypeInt, kTypeObject },
	/*  192 */ { kTypeObject, kTypeObject, kTypeInt },
	/*  193 */ { kTypeObject, kTypeObject, kTypeInt },
	/*  194 */ { kTypeVoid, kTypeObject },
	/*  195 */ { kTypeInt },
	/*  196 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  197 */ { kTypeObject, kTypeString },
	/*  198 */ { kTypeObject, kTypeObject },
	/*  199 */ { kTypeEngineType0, kTypeEngineType0, kTypeEngineType0 },
	/*  200 */ { kTypeObject, kTypeString, kTypeInt },
	/*  201 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  202 */ { kTypeVoid, kTypeFloat },
	/*  203 */ { kTypeVoid, kTypeInt, kTypeString },
	/*  204 */ { kTypeVoid, kTypeObject, kTypeString, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  205 */ { kTypeVoid },
	/*  206 */ { kTypeVoid },
	/*  207 */ { kTypeEngineType0, kTypeInt, kTypeObject, kTypeInt, kTypeInt },
	/*  208 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  209 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt },
	/*  210 */ { kTypeObject, kTypeObject },
	/*  211 */ { kTypeObject, kTypeObject },
	/*  212 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*  213 */ { kTypeEngineType2, kTypeObject },
	/*  214 */ { kTypeVoid, kTypeEngineType2 },
	/*  215 */ { kTypeEngineType2, kTypeObject, kTypeVector, kTypeFloat },
	/*  216 */ { kTypeVoid, kTypeInt, kTypeEngineType0, kTypeEngineType2, kTypeFloat },
	/*  217 */ { kTypeInt, kTypeObject },
	/*  218 */ { kTypeFloat, kTypeFloat },
	/*  219 */ { kTypeFloat, kTypeFloat },
	/*  220 */ { kTypeVoid, kTypeInt, kTypeEngineType0, kTypeObject, kTypeFloat },
	/*  221 */ { kTypeVoid, kTypeString, kTypeInt },
	/*  222 */ { kTypeEngineType2 },
	/*  223 */ { kTypeVector, kTypeEngineType2 },
	/*  224 */ { kTypeObject, kTypeEngineType2 },
	/*  225 */ { kTypeFloat, kTypeEngineType2 },
	/*  226 */ { kTypeObject, kTypeInt, kTypeInt, kTypeEngineType2, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  227 */ { kTypeObject, kTypeInt, kTypeObject, kTypeInt },
	/*  228 */ { kTypeObject, kTypeInt, kTypeEngineType2, kTypeInt },
	/*  229 */ { kTypeObject, kTypeString, kTypeObject, kTypeInt },
	/*  230 */ { kTypeFloat, kTypeInt },
	/*  231 */ { kTypeInt, kTypeFloat },
	/*  232 */ { kTypeInt, kTypeString },
	/*  233 */ { kTypeFloat, kTypeString },
	/*  234 */ { kTypeVoid, kTypeInt, kTypeEngineType2, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  235 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  236 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  237 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  238 */ { kTypeObject },
	/*  239 */ { kTypeString, kTypeInt, kTypeInt },
	/*  240 */ { kTypeVoid, kTypeInt, kTypeInt },
	/*  241 */ { kTypeVoid, kTypeObject, kTypeFloat, kTypeInt },
	/*  242 */ { kTypeObject },
	/*  243 */ { kTypeObject, kTypeInt, kTypeString, kTypeEngineType2, kTypeInt, kTypeString },
	/*  244 */ { kTypeEngineType1, kTypeObject, kTypeInt, kTypeInt },
	/*  245 */ { kTypeObject },
	/*  246 */ { kTypeInt },
	/*  247 */ { kTypeInt },
	/*  248 */ { kTypeInt },
	/*  249 */ { kTypeString },
	/*  250 */ { kTypeEngineType0, kTypeInt },
	/*  251 */ { kTypeEngineType0, kTypeInt },
	/*  252 */ { kTypeEngineType0 },
	/*  253 */ { kTypeString, kTypeObject },
	/*  254 */ { kTypeObject },
	/*  255 */ { kTypeInt, kTypeString, kTypeObject, kTypeInt },
	/*  256 */ { kTypeObject },
	/*  257 */ { kTypeInt },
	/*  258 */ { kTypeInt },
	/*  259 */ { kTypeInt },
	/*  260 */ { kTypeObject },
	/*  261 */ { kTypeInt },
	/*  262 */ { kTypeObject, kTypeObject, kTypeInt, kTypeInt },
	/*  263 */ { kTypeObject, kTypeObject, kTypeInt, kTypeInt },
	/*  264 */ { kTypeObject, kTypeObject },
	/*  265 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  266 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  267 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  268 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  269 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  270 */ { kTypeEngineType0 },
	/*  271 */ { kTypeEngineType0 },
	/*  272 */ { kTypeString, kTypeObject },
	/*  273 */ { kTypeEngineType0, kTypeInt },
	/*  274 */ { kTypeInt, kTypeObject, kTypeInt, kTypeObject },
	/*  275 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*  276 */ { kTypeInt, kTypeObject },
	/*  277 */ { kTypeVoid, kTypeInt, kTypeObject },
	/*  278 */ { kTypeInt, kTypeObject },
	/*  279 */ { kTypeVoid, kTypeInt, kTypeObject },
	/*  280 */ { kTypeInt, kTypeObject },
	/*  281 */ { kTypeVoid, kTypeInt, kTypeObject },
	/*  282 */ { kTypeObject },
	/*  283 */ { kTypeObject },
	/*  284 */ { kTypeVoid, kTypeInt, kTypeString },
	/*  285 */ { kTypeInt, kTypeInt, kTypeObject, kTypeInt },
	/*  286 */ { kTypeInt, kTypeInt, kTypeObject },
	/*  287 */ { kTypeVoid, kTypeInt, kTypeObject },
	/*  288 */ { kTypeInt, kTypeInt, kTypeObject, kTypeInt, kTypeObject },
	/*  289 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  290 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  291 */ { kTypeObject },
	/*  292 */ { kTypeObject },
	/*  293 */ { kTypeObject },
	/*  294 */ { kTypeVoid, kTypeScriptState },
	/*  295 */ { kTypeEngineType1 },
	/*  296 */ { kTypeVoid, kTypeInt, kTypeObject },
	/*  297 */ { kTypeInt, kTypeObject },
	/*  298 */ { kTypeFloat, kTypeEngineType2, kTypeEngineType2 },
	/*  299 */ { kTypeInt, kTypeInt, kTypeObject, kTypeInt, kTypeInt, kTypeObject },
	/*  300 */ { kTypeVoid, kTypeInt, kTypeFloat, kTypeFloat },
	/*  301 */ { kTypeEngineType3, kTypeInt },
	/*  302 */ { kTypeEngineType3, kTypeInt },
	/*  303 */ { kTypeEngineType3, kTypeInt },
	/*  304 */ { kTypeInt, kTypeInt, kTypeObject },
	/*  305 */ { kTypeInt, kTypeEngineType0 },
	/*  306 */ { kTypeInt, kTypeEngineType3, kTypeObject },
	/*  307 */ { kTypeEngineType3, kTypeInt, kTypeObject, kTypeInt },
	/*  308 */ { kTypeEngineType3, kTypeInt, kTypeInt, kTypeObject, kTypeInt },
	/*  309 */ { kTypeVoid, kTypeEngineType3, kTypeObject },
	/*  310 */ { kTypeVoid, kTypeEngineType3, kTypeEngineType2 },
	/*  311 */ { kTypeInt, kTypeObject },
	/*  312 */ { kTypeInt, kTypeObject },
	/*  313 */ { kTypeVoid, kTypeEngineType2 },
	/*  314 */ { kTypeEngineType0, kTypeInt },
	/*  315 */ { kTypeInt, kTypeInt, kTypeObject, kTypeInt },
	/*  316 */ { kTypeObject, kTypeObject },
	/*  317 */ { kTypeInt, kTypeObject },
	/*  318 */ { kTypeInt, kTypeObject },
	/*  319 */ { kTypeObject, kTypeObject },
	/*  320 */ { kTypeInt, kTypeObject },
	/*  321 */ { kTypeInt, kTypeObject },
	/*  322 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  323 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeInt },
	/*  324 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  325 */ { kTypeInt, kTypeObject },
	/*  326 */ { kTypeObject },
	/*  327 */ { kTypeVoid, kTypeObject },
	/*  328 */ { kTypeObject, kTypeObject },
	/*  329 */ { kTypeVoid, kTypeObject },
	/*  330 */ { kTypeObject },
	/*  331 */ { kTypeInt, kTypeInt, kTypeObject },
	/*  332 */ { kTypeInt, kTypeObject },
	/*  333 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  334 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  335 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  336 */ { kTypeObject },
	/*  337 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  338 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  339 */ { kTypeObject, kTypeObject },
	/*  340 */ { kTypeObject, kTypeObject },
	/*  341 */ { kTypeInt, kTypeInt, kTypeObject },
	/*  342 */ { kTypeInt, kTypeInt, kTypeObject },
	/*  343 */ { kTypeInt, kTypeInt, kTypeObject },
	/*  344 */ { kTypeInt, kTypeInt },
	/*  345 */ { kTypeInt },
	/*  346 */ { kTypeObject, kTypeObject },
	/*  347 */ { kTypeObject },
	/*  348 */ { kTypeObject },
	/*  349 */ { kTypeObject },
	/*  350 */ { kTypeObject },
	/*  351 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*  352 */ { kTypeInt },
	/*  353 */ { kTypeObject },
	/*  354 */ { kTypeObject, kTypeObject, kTypeInt },
	/*  355 */ { kTypeEngineType0, kTypeEngineType0, kTypeInt, kTypeInt },
	/*  356 */ { kTypeEngineType0, kTypeEngineType0, kTypeInt },
	/*  357 */ { kTypeEngineType0, kTypeEngineType0 },
	/*  358 */ { kTypeInt, kTypeObject },
	/*  359 */ { kTypeInt, kTypeEngineType3 },
	/*  360 */ { kTypeVoid, kTypeEngineType2, kTypeInt, kTypeFloat },
	/*  361 */ { kTypeObject },
	/*  362 */ { kTypeInt, kTypeEngineType3 },
	/*  363 */ { kTypeInt, kTypeEngineType3 },
	/*  364 */ { kTypeObject, kTypeInt, kTypeObject, kTypeInt },
	/*  365 */ { kTypeVoid, kTypeObject, kTypeObject },
	/*  366 */ { kTypeVoid, kTypeObject, kTypeObject },
	/*  367 */ { kTypeVoid, kTypeString, kTypeInt, kTypeObject, kTypeInt, kTypeInt, kTypeInt },
	/*  368 */ { kTypeVoid, kTypeString, kTypeObject, kTypeInt, kTypeInt },
	/*  369 */ { kTypeString, kTypeObject },
	/*  370 */ { kTypeString, kTypeObject },
	/*  371 */ { kTypeString, kTypeObject },
	/*  372 */ { kTypeVoid, kTypeObject, kTypeObject },
	/*  373 */ { kTypeVoid, kTypeObject, kTypeObject },
	/*  374 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  375 */ { kTypeObject },
	/*  376 */ { kTypeObject },
	/*  377 */ { kTypeInt, kTypeInt, kTypeObject },
	/*  378 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt, kTypeInt },
	/*  379 */ { kTypeEngineType0 },
	/*  380 */ { kTypeObject, kTypeObject, kTypeInt },
	/*  381 */ { kTypeObject, kTypeObject, kTypeInt },
	/*  382 */ { kTypeVoid, kTypeEngineType2, kTypeInt, kTypeFloat },
	/*  383 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat, kTypeFloat },
	/*  384 */ { kTypeInt, kTypeString },
	/*  385 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  386 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  387 */ { kTypeEngineType0, kTypeFloat },
	/*  388 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  389 */ { kTypeVoid, kTypeObject, kTypeObject },
	/*  390 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt, kTypeFloat },
	/*  391 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt, kTypeFloat },
	/*  392 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt, kTypeFloat },
	/*  393 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  394 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  395 */ { kTypeInt, kTypeObject },
	/*  396 */ { kTypeString, kTypeInt },
	/*  397 */ { kTypeInt, kTypeObject },
	/*  398 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  399 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  400 */ { kTypeVoid, kTypeObject },
	/*  401 */ { kTypeInt, kTypeObject },
	/*  402 */ { kTypeVoid, kTypeInt },
	/*  403 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt },
	/*  404 */ { kTypeVoid },
	/*  405 */ { kTypeInt },
	/*  406 */ { kTypeInt },
	/*  407 */ { kTypeInt },
	/*  408 */ { kTypeInt },
	/*  409 */ { kTypeInt, kTypeObject },
	/*  410 */ { kTypeObject },
	/*  411 */ { kTypeEngineType2 },
	/*  412 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  413 */ { kTypeVoid, kTypeObject },
	/*  414 */ { kTypeVoid, kTypeObject },
	/*  415 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  416 */ { kTypeVoid, kTypeObject, kTypeVector },
	/*  417 */ { kTypeVoid, kTypeString, kTypeObject, kTypeInt },
	/*  418 */ { kTypeInt, kTypeObject },
	/*  419 */ { kTypeObject },
	/*  420 */ { kTypeInt, kTypeObject },
	/*  421 */ { kTypeVoid, kTypeInt, kTypeObject },
	/*  422 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  423 */ { kTypeInt },
	/*  424 */ { kTypeEngineType1, kTypeObject, kTypeEngineType2, kTypeObject },
	/*  425 */ { kTypeVoid, kTypeObject },
	/*  426 */ { kTypeVoid, kTypeObject },
	/*  427 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  428 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  429 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  430 */ { kTypeVoid, kTypeObject },
	/*  431 */ { kTypeVoid, kTypeObject },
	/*  432 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  433 */ { kTypeVoid, kTypeObject },
	/*  434 */ { kTypeVoid, kTypeObject },
	/*  435 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  436 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  437 */ { kTypeObject },
	/*  438 */ { kTypeObject },
	/*  439 */ { kTypeObject },
	/*  440 */ { kTypeObject },
	/*  441 */ { kTypeEngineType2 },
	/*  442 */ { kTypeObject },
	/*  443 */ { kTypeInt, kTypeObject },
	/*  444 */ { kTypeVoid, kTypeInt, kTypeObject, kTypeInt, kTypeInt },
	/*  445 */ { kTypeInt, kTypeObject },
	/*  446 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*  447 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*  448 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*  449 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*  450 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/*  451 */ { kTypeEngineType0, kTypeInt },
	/*  452 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/*  453 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*  454 */ { kTypeEngineType0, kTypeInt },
	/*  455 */ { kTypeInt, kTypeObject },
	/*  456 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  457 */ { kTypeEngineType0, kTypeInt },
	/*  458 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*  459 */ { kTypeEngineType0 },
	/*  460 */ { kTypeEngineType0, kTypeInt, kTypeScriptState },
	/*  461 */ { kTypeEngineType0 },
	/*  462 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*  463 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/*  464 */ { kTypeEngineType0, kTypeInt },
	/*  465 */ { kTypeEngineType0 },
	/*  466 */ { kTypeEngineType0 },
	/*  467 */ { kTypeEngineType0 },
	/*  468 */ { kTypeEngineType0 },
	/*  469 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  470 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  471 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  472 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/*  473 */ { kTypeEngineType0, kTypeInt, kTypeScriptState },
	/*  474 */ { kTypeVoid, kTypeObject, kTypeString, kTypeString, kTypeString, kTypeInt },
	/*  475 */ { kTypeInt, kTypeObject },
	/*  476 */ { kTypeVoid },
	/*  477 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*  478 */ { kTypeInt, kTypeObject },
	/*  479 */ { kTypeInt, kTypeObject },
	/*  480 */ { kTypeEngineType0, kTypeEngineType2, kTypeInt },
	/*  481 */ { kTypeEngineType0, kTypeInt },
	/*  482 */ { kTypeEngineType0, kTypeInt },
	/*  483 */ { kTypeVoid, kTypeObject },
	/*  484 */ { kTypeVoid, kTypeObject },
	/*  485 */ { kTypeEngineType0, kTypeInt },
	/*  486 */ { kTypeObject, kTypeObject },
	/*  487 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/*  488 */ { kTypeObject, kTypeObject, kTypeInt },
	/*  489 */ { kTypeString, kTypeObject },
	/*  490 */ { kTypeInt, kTypeObject },
	/*  491 */ { kTypeInt, kTypeObject },
	/*  492 */ { kTypeInt, kTypeObject },
	/*  493 */ { kTypeInt, kTypeObject },
	/*  494 */ { kTypeFloat, kTypeObject },
	/*  495 */ { kTypeInt, kTypeObject },
	/*  496 */ { kTypeInt, kTypeObject },
	/*  497 */ { kTypeInt, kTypeObject },
	/*  498 */ { kTypeInt, kTypeObject },
	/*  499 */ { kTypeString, kTypeObject },
	/*  500 */ { kTypeString, kTypeObject },
	/*  501 */ { kTypeVoid, kTypeInt, kTypeObject, kTypeInt },
	/*  502 */ { kTypeVoid, kTypeInt, kTypeEngineType2, kTypeInt },
	/*  503 */ { kTypeVoid, kTypeObject, kTypeObject },
	/*  504 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  505 */ { kTypeInt, kTypeObject },
	/*  506 */ { kTypeObject },
	/*  507 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  508 */ { kTypeInt },
	/*  509 */ { kTypeVoid, kTypeString, kTypeString },
	/*  510 */ { kTypeEngineType0, kTypeInt, kTypeString, kTypeString, kTypeString, kTypeString },
	/*  511 */ { kTypeInt, kTypeObject },
	/*  512 */ { kTypeVoid },
	/*  513 */ { kTypeInt },
	/*  514 */ { kTypeVoid, kTypeEngineType2, kTypeInt, kTypeInt },
	/*  515 */ { kTypeVoid, kTypeEngineType2, kTypeInt, kTypeInt },
	/*  516 */ { kTypeVoid, kTypeObject },
	/*  517 */ { kTypeInt, kTypeEngineType2 },
	/*  518 */ { kTypeInt, kTypeEngineType2 },
	/*  519 */ { kTypeInt, kTypeEngineType2 },
	/*  520 */ { kTypeInt, kTypeEngineType2 },
	/*  521 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  522 */ { kTypeInt, kTypeObject },
	/*  523 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeObject },
	/*  524 */ { kTypeInt, kTypeInt, kTypeObject },
	/*  525 */ { kTypeVoid, kTypeInt, kTypeObject, kTypeInt, kTypeFloat, kTypeInt, kTypeInt, kTypeFloat, kTypeVector },
	/*  526 */ { kTypeVoid, kTypeString, kTypeObject, kTypeInt, kTypeFloat, kTypeInt, kTypeInt, kTypeFloat, kTypeVector },
	/*  527 */ { kTypeInt, kTypeObject },
	/*  528 */ { kTypeInt, kTypeObject },
	/*  529 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  530 */ { kTypeInt, kTypeObject },
	/*  531 */ { kTypeInt, kTypeObject },
	/*  532 */ { kTypeInt, kTypeObject },
	/*  533 */ { kTypeObject, kTypeObject },
	/*  534 */ { kTypeString, kTypeObject },
	/*  535 */ { kTypeInt, kTypeObject },
	/*  536 */ { kTypeInt, kTypeObject },
	/*  537 */ { kTypeInt, kTypeObject },
	/*  538 */ { kTypeString, kTypeObject },
	/*  539 */ { kTypeInt, kTypeObject },
	/*  540 */ { kTypeInt, kTypeObject },
	/*  541 */ { kTypeInt, kTypeObject },
	/*  542 */ { kTypeObject },
	/*  543 */ { kTypeInt, kTypeInt, kTypeObject },
	/*  544 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  545 */ { kTypeInt, kTypeObject },
	/*  546 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  547 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  548 */ { kTypeObject, kTypeInt },
	/*  549 */ { kTypeObject, kTypeInt },
	/*  550 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  551 */ { kTypeInt, kTypeObject },
	/*  552 */ { kTypeEngineType0, kTypeInt },
	/*  553 */ { kTypeEngineType0, kTypeInt },
	/*  554 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeString },
	/*  555 */ { kTypeVoid, kTypeObject },
	/*  556 */ { kTypeObject, kTypeObject },
	/*  557 */ { kTypeVoid },
	/*  558 */ { kTypeInt, kTypeObject },
	/*  559 */ { kTypeInt, kTypeObject },
	/*  560 */ { kTypeVoid, kTypeString },
	/*  561 */ { kTypeString },
	/*  562 */ { kTypeObject, kTypeObject },
	/*  563 */ { kTypeVoid, kTypeString },
	/*  564 */ { kTypeVoid, kTypeString },
	/*  565 */ { kTypeVoid, kTypeObject },
	/*  566 */ { kTypeVoid, kTypeObject },
	/*  567 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  568 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  569 */ { kTypeInt, kTypeObject },
	/*  570 */ { kTypeInt, kTypeObject },
	/*  571 */ { kTypeFloat, kTypeInt },
	/*  572 */ { kTypeVoid, kTypeObject, kTypeObject },
	/*  573 */ { kTypeVoid, kTypeObject },
	/*  574 */ { kTypeInt, kTypeObject },
	/*  575 */ { kTypeInt, kTypeObject },
	/*  576 */ { kTypeInt, kTypeObject },
	/*  577 */ { kTypeInt, kTypeObject },
	/*  578 */ { kTypeVoid },
	/*  579 */ { kTypeInt },
	/*  580 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  581 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  582 */ { kTypeString, kTypeObject },
	/*  583 */ { kTypeEngineType0 },
	/*  584 */ { kTypeObject, kTypeObject, kTypeObject, kTypeInt },
	/*  585 */ { kTypeEngineType0 },
	/*  586 */ { kTypeInt, kTypeObject },
	/*  587 */ { kTypeInt, kTypeObject },
	/*  588 */ { kTypeInt, kTypeObject },
	/*  589 */ { kTypeVoid, kTypeString, kTypeString, kTypeFloat, kTypeObject },
	/*  590 */ { kTypeVoid, kTypeString, kTypeString, kTypeInt, kTypeObject },
	/*  591 */ { kTypeVoid, kTypeString, kTypeString, kTypeVector, kTypeObject },
	/*  592 */ { kTypeVoid, kTypeString, kTypeString, kTypeEngineType2, kTypeObject },
	/*  593 */ { kTypeVoid, kTypeString, kTypeString, kTypeString, kTypeObject },
	/*  594 */ { kTypeVoid, kTypeString },
	/*  595 */ { kTypeFloat, kTypeString, kTypeString, kTypeObject },
	/*  596 */ { kTypeInt, kTypeString, kTypeString, kTypeObject },
	/*  597 */ { kTypeVector, kTypeString, kTypeString, kTypeObject },
	/*  598 */ { kTypeEngineType2, kTypeString, kTypeString, kTypeObject },
	/*  599 */ { kTypeString, kTypeString, kTypeString, kTypeObject },
	/*  600 */ { kTypeObject, kTypeObject, kTypeEngineType2, kTypeObject, kTypeString },
	/*  601 */ { kTypeVoid, kTypeString, kTypeString, kTypeObject },
	/*  602 */ { kTypeInt, kTypeString, kTypeString, kTypeObject, kTypeObject },
	/*  603 */ { kTypeObject, kTypeString, kTypeString, kTypeEngineType2, kTypeObject, kTypeObject },
	/*  604 */ { kTypeEngineType0 },
	/*  605 */ { kTypeInt, kTypeObject },
	/*  606 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  607 */ { kTypeInt, kTypeObject },
	/*  608 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  609 */ { kTypeVoid, kTypeInt, kTypeEngineType4, kTypeObject, kTypeFloat },
	/*  610 */ { kTypeVoid, kTypeObject, kTypeEngineType4 },
	/*  611 */ { kTypeInt, kTypeEngineType4 },
	/*  612 */ { kTypeEngineType4, kTypeObject },
	/*  613 */ { kTypeEngineType4, kTypeObject },
	/*  614 */ { kTypeInt, kTypeEngineType4 },
	/*  615 */ { kTypeInt, kTypeEngineType4 },
	/*  616 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  617 */ { kTypeEngineType4, kTypeInt },
	/*  618 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  619 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  620 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  621 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  622 */ { kTypeEngineType4, kTypeInt },
	/*  623 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  624 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  625 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  626 */ { kTypeEngineType4, kTypeInt },
	/*  627 */ { kTypeEngineType4, kTypeInt },
	/*  628 */ { kTypeEngineType4, kTypeInt },
	/*  629 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  630 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  631 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  632 */ { kTypeEngineType4, kTypeInt, kTypeInt, kTypeInt },
	/*  633 */ { kTypeEngineType4, kTypeInt, kTypeInt, kTypeInt },
	/*  634 */ { kTypeEngineType4, kTypeInt, kTypeInt, kTypeInt },
	/*  635 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  636 */ { kTypeEngineType4, kTypeInt },
	/*  637 */ { kTypeEngineType4, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  638 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  639 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  640 */ { kTypeEngineType4 },
	/*  641 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  642 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  643 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  644 */ { kTypeEngineType4, kTypeInt },
	/*  645 */ { kTypeEngineType4, kTypeInt },
	/*  646 */ { kTypeEngineType4, kTypeInt },
	/*  647 */ { kTypeEngineType4 },
	/*  648 */ { kTypeEngineType4 },
	/*  649 */ { kTypeEngineType4, kTypeInt },
	/*  650 */ { kTypeEngineType4 },
	/*  651 */ { kTypeEngineType4, kTypeInt },
	/*  652 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  653 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  654 */ { kTypeEngineType4 },
	/*  655 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  656 */ { kTypeEngineType4, kTypeInt },
	/*  657 */ { kTypeEngineType4 },
	/*  658 */ { kTypeEngineType4, kTypeInt, kTypeInt, kTypeInt },
	/*  659 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  660 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  661 */ { kTypeEngineType4, kTypeInt },
	/*  662 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  663 */ { kTypeEngineType4, kTypeInt },
	/*  664 */ { kTypeEngineType4, kTypeInt },
	/*  665 */ { kTypeEngineType4, kTypeInt },
	/*  666 */ { kTypeEngineType4, kTypeInt },
	/*  667 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  668 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  669 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  670 */ { kTypeEngineType4, kTypeInt },
	/*  671 */ { kTypeEngineType4, kTypeInt },
	/*  672 */ { kTypeEngineType4, kTypeInt },
	/*  673 */ { kTypeEngineType4, kTypeInt },
	/*  674 */ { kTypeEngineType4, kTypeInt },
	/*  675 */ { kTypeEngineType4, kTypeInt },
	/*  676 */ { kTypeEngineType4, kTypeInt },
	/*  677 */ { kTypeEngineType4, kTypeInt },
	/*  678 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  679 */ { kTypeEngineType4 },
	/*  680 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  681 */ { kTypeEngineType4, kTypeInt },
	/*  682 */ { kTypeEngineType4, kTypeInt },
	/*  683 */ { kTypeEngineType4 },
	/*  684 */ { kTypeEngineType4, kTypeInt },
	/*  685 */ { kTypeEngineType4, kTypeInt },
	/*  686 */ { kTypeEngineType4, kTypeInt },
	/*  687 */ { kTypeEngineType4, kTypeInt },
	/*  688 */ { kTypeEngineType4, kTypeInt },
	/*  689 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt, kTypeInt },
	/*  690 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*  691 */ { kTypeVoid, kTypeInt, kTypeInt },
	/*  692 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  693 */ { kTypeObject },
	/*  694 */ { kTypeFloat, kTypeInt },
	/*  695 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/*  696 */ { kTypeVoid, kTypeObject, kTypeFloat, kTypeFloat, kTypeInt },
	/*  697 */ { kTypeVoid, kTypeObject },
	/*  698 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  699 */ { kTypeInt, kTypeObject },
	/*  700 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  701 */ { kTypeVoid, kTypeObject, kTypeObject },
	/*  702 */ { kTypeVoid },
	/*  703 */ { kTypeVoid },
	/*  704 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt, kTypeInt },
	/*  705 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  706 */ { kTypeInt, kTypeObject },
	/*  707 */ { kTypeObject },
	/*  708 */ { kTypeInt, kTypeObject },
	/*  709 */ { kTypeVoid, kTypeInt, kTypeInt },
	/*  710 */ { kTypeString, kTypeString, kTypeString, kTypeInt },
	/*  711 */ { kTypeEngineType0 },
	/*  712 */ { kTypeInt, kTypeObject },
	/*  713 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  714 */ { kTypeInt, kTypeObject },
	/*  715 */ { kTypeVoid, kTypeObject },
	/*  716 */ { kTypeInt, kTypeObject },
	/*  717 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  718 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  719 */ { kTypeVoid, kTypeObject },
	/*  720 */ { kTypeVoid, kTypeInt, kTypeInt },
	/*  721 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  722 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  723 */ { kTypeInt, kTypeObject },
	/*  724 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  725 */ { kTypeInt, kTypeObject },
	/*  726 */ { kTypeInt, kTypeObject },
	/*  727 */ { kTypeObject },
	/*  728 */ { kTypeObject },
	/*  729 */ { kTypeObject },
	/*  730 */ { kTypeObject },
	/*  731 */ { kTypeObject, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  732 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt },
	/*  733 */ { kTypeEngineType4, kTypeInt, kTypeInt },
	/*  734 */ { kTypeInt, kTypeEngineType4 },
	/*  735 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  736 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  737 */ { kTypeInt, kTypeObject },
	/*  738 */ { kTypeVoid, kTypeObject },
	/*  739 */ { kTypeEngineType4, kTypeInt },
	/*  740 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  741 */ { kTypeInt, kTypeObject },
	/*  742 */ { kTypeFloat, kTypeObject },
	/*  743 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/*  744 */ { kTypeInt, kTypeObject },
	/*  745 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  746 */ { kTypeVoid, kTypeInt },
	/*  747 */ { kTypeInt },
	/*  748 */ { kTypeInt, kTypeObject },
	/*  749 */ { kTypeInt, kTypeObject },
	/*  750 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/*  751 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/*  752 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  753 */ { kTypeInt, kTypeVector, kTypeVector },
	/*  754 */ { kTypeInt },
	/*  755 */ { kTypeVoid, kTypeInt, kTypeObject },
	/*  756 */ { kTypeVoid, kTypeObject },
	/*  757 */ { kTypeEngineType0 },
	/*  758 */ { kTypeEngineType4, kTypeInt },
	/*  759 */ { kTypeInt, kTypeObject },
	/*  760 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  761 */ { kTypeInt, kTypeObject },
	/*  762 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  763 */ { kTypeInt, kTypeObject },
	/*  764 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  765 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  766 */ { kTypeInt, kTypeObject },
	/*  767 */ { kTypeEngineType0 },
	/*  768 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  769 */ { kTypeInt, kTypeEngineType4 },
	/*  770 */ { kTypeInt, kTypeEngineType4 },
	/*  771 */ { kTypeInt, kTypeEngineType4 },
	/*  772 */ { kTypeInt, kTypeEngineType4 },
	/*  773 */ { kTypeInt, kTypeObject },
	/*  774 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  775 */ { kTypeVoid, kTypeObject },
	/*  776 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/*  777 */ { kTypeInt, kTypeString, kTypeInt },
	/*  778 */ { kTypeInt, kTypeString, kTypeInt },
	/*  779 */ { kTypeInt, kTypeString, kTypeString },
	/*  780 */ { kTypeInt, kTypeString, kTypeFloat },
	/*  781 */ { kTypeInt, kTypeString },
	/*  782 */ { kTypeInt, kTypeString },
	/*  783 */ { kTypeString, kTypeString },
	/*  784 */ { kTypeFloat, kTypeString },
	/*  785 */ { kTypeInt, kTypeString },
	/*  786 */ { kTypeInt, kTypeString },
	/*  787 */ { kTypeVoid, kTypeObject, kTypeObject },
	/*  788 */ { kTypeVoid, kTypeObject, kTypeObject },
	/*  789 */ { kTypeInt, kTypeString, kTypeObject },
	/*  790 */ { kTypeEngineType0 },
	/*  791 */ { kTypeEngineType0, kTypeString },
	/*  792 */ { kTypeEngineType0, kTypeString, kTypeObject, kTypeVector },
	/*  793 */ { kTypeInt, kTypeInt },
	/*  794 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  795 */ { kTypeVoid, kTypeInt, kTypeInt },
	/*  796 */ { kTypeVoid, kTypeObject, kTypeScriptState },
	/*  797 */ { kTypeInt, kTypeObject },
	/*  798 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  799 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  800 */ { kTypeEngineType0 },
	/*  801 */ { kTypeEngineType0 },
	/*  802 */ { kTypeEngineType0, kTypeFloat, kTypeFloat, kTypeFloat },
	/*  803 */ { kTypeEngineType0, kTypeObject, kTypeInt, kTypeInt },
	/*  804 */ { kTypeEngineType0, kTypeObject },
	/*  805 */ { kTypeEngineType0 },
	/*  806 */ { kTypeInt },
	/*  807 */ { kTypeEngineType0, kTypeInt, kTypeFloat, kTypeInt, kTypeInt },
	/*  808 */ { kTypeEngineType0, kTypeInt },
	/*  809 */ { kTypeEngineType0, kTypeInt },
	/*  810 */ { kTypeEngineType0, kTypeInt, kTypeFloat },
	/*  811 */ { kTypeInt },
	/*  812 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt, kTypeFloat, kTypeFloat, kTypeFloat },
	/*  813 */ { kTypeEngineType0 },
	/*  814 */ { kTypeVoid, kTypeObject, kTypeString, kTypeInt, kTypeInt, kTypeFloat, kTypeInt },
	/*  815 */ { kTypeInt, kTypeObject },
	/*  816 */ { kTypeEngineType0, kTypeObject, kTypeInt },
	/*  817 */ { kTypeEngineType0, kTypeObject },
	/*  818 */ { kTypeEngineType0, kTypeObject, kTypeInt },
	/*  819 */ { kTypeEngineType0, kTypeInt },
	/*  820 */ { kTypeObject },
	/*  821 */ { kTypeObject },
	/*  822 */ { kTypeInt, kTypeString, kTypeString },
	/*  823 */ { kTypeInt, kTypeString, kTypeObject },
	/*  824 */ { kTypeInt, kTypeString },
	/*  825 */ { kTypeInt, kTypeString },
	/*  826 */ { kTypeInt, kTypeString },
	/*  827 */ { kTypeInt, kTypeString, kTypeInt },
	/*  828 */ { kTypeObject, kTypeString },
	/*  829 */ { kTypeString, kTypeObject },
	/*  830 */ { kTypeObject, kTypeString, kTypeEngineType2 },
	/*  831 */ { kTypeInt, kTypeString },
	/*  832 */ { kTypeInt, kTypeString, kTypeObject },
	/*  833 */ { kTypeVoid, kTypeString, kTypeObject, kTypeInt },
	/*  834 */ { kTypeString },
	/*  835 */ { kTypeString },
	/*  836 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeEngineType2, kTypeEngineType2, kTypeInt, kTypeInt },
	/*  837 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeEngineType2, kTypeEngineType2, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  838 */ { kTypeInt, kTypeObject },
	/*  839 */ { kTypeObject, kTypeObject, kTypeObject },
	/*  840 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  841 */ { kTypeFloat, kTypeEngineType2, kTypeEngineType2, kTypeInt, kTypeInt },
	/*  842 */ { kTypeVoid, kTypeInt },
	/*  843 */ { kTypeInt },
	/*  844 */ { kTypeInt, kTypeString, kTypeInt },
	/*  845 */ { kTypeInt, kTypeString },
	/*  846 */ { kTypeInt, kTypeObject },
	/*  847 */ { kTypeVoid, kTypeString, kTypeObject, kTypeString },
	/*  848 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt, kTypeFloat },
	/*  849 */ { kTypeInt },
	/*  850 */ { kTypeVoid, kTypeObject, kTypeString, kTypeInt, kTypeString, kTypeInt },
	/*  851 */ { kTypeEngineType0, kTypeFloat, kTypeScriptState },
	/*  852 */ { kTypeVoid, kTypeString, kTypeString },
	/*  853 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  854 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  855 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeString },
	/*  856 */ { kTypeString, kTypeObject, kTypeInt },
	/*  857 */ { kTypeInt, kTypeObject },
	/*  858 */ { kTypeVoid, kTypeObject, kTypeObject },
	/*  859 */ { kTypeInt, kTypeObject },
	/*  860 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeString, kTypeString, kTypeString, kTypeInt, kTypeString, kTypeInt, kTypeString, kTypeInt, kTypeString },
	/*  861 */ { kTypeInt, kTypeString, kTypeString, kTypeInt },
	/*  862 */ { kTypeInt, kTypeString },
	/*  863 */ { kTypeObject, kTypeObject },
	/*  864 */ { kTypeObject, kTypeObject },
	/*  865 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  866 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  867 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  868 */ { kTypeInt, kTypeObject },
	/*  869 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  870 */ { kTypeInt, kTypeObject },
	/*  871 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  872 */ { kTypeVoid, kTypeObject },
	/*  873 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  874 */ { kTypeEngineType2, kTypeEngineType2, kTypeEngineType2, kTypeFloat, kTypeFloat, kTypeInt },
	/*  875 */ { kTypeEngineType2, kTypeObject, kTypeEngineType2, kTypeFloat, kTypeInt, kTypeInt },
	/*  876 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  877 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt, kTypeInt },
	/*  878 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt, kTypeFloat, kTypeFloat },
	/*  879 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  880 */ { kTypeEngineType0, kTypeInt },
	/*  881 */ { kTypeVoid, kTypeObject, kTypeString, kTypeString, kTypeInt },
	/*  882 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  883 */ { kTypeInt },
	/*  884 */ { kTypeInt, kTypeObject },
	/*  885 */ { kTypeString },
	/*  886 */ { kTypeVoid, kTypeObject, kTypeString, kTypeInt, kTypeString },
	/*  887 */ { kTypeVoid, kTypeObject, kTypeString, kTypeString, kTypeInt },
	/*  888 */ { kTypeVoid, kTypeObject, kTypeString, kTypeString, kTypeInt, kTypeString },
	/*  889 */ { kTypeInt, kTypeObject },
	/*  890 */ { kTypeEngineType0, kTypeInt },
	/*  891 */ { kTypeEngineType0 },
	/*  892 */ { kTypeInt, kTypeEngineType0, kTypeInt },
	/*  893 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/*  894 */ { kTypeEngineType0, kTypeEngineType0, kTypeInt },
	/*  895 */ { kTypeEngineType0, kTypeInt },
	/*  896 */ { kTypeInt, kTypeObject },
	/*  897 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  898 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  899 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  900 */ { kTypeString, kTypeObject },
	/*  901 */ { kTypeString, kTypeObject },
	/*  902 */ { kTypeString, kTypeObject },
	/*  903 */ { kTypeInt, kTypeObject },
	/*  904 */ { kTypeInt, kTypeObject, kTypeString, kTypeInt, kTypeFloat },
	/*  905 */ { kTypeEngineType0 },
	/*  906 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeString, kTypeString, kTypeString, kTypeInt, kTypeString, kTypeInt, kTypeString, kTypeInt, kTypeString, kTypeString, kTypeString },
	/*  907 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt },
	/*  908 */ { kTypeVoid, kTypeObject, kTypeVector, kTypeInt },
	/*  909 */ { kTypeInt, kTypeObject },
	/*  910 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  911 */ { kTypeInt },
	/*  912 */ { kTypeObject },
	/*  913 */ { kTypeEngineType0, kTypeInt },
	/*  914 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeObject },
	/*  915 */ { kTypeObject },
	/*  916 */ { kTypeObject },
	/*  917 */ { kTypeInt, kTypeObject },
	/*  918 */ { kTypeInt, kTypeObject },
	/*  919 */ { kTypeObject, kTypeObject },
	/*  920 */ { kTypeEngineType0 },
	/*  921 */ { kTypeInt, kTypeObject },
	/*  922 */ { kTypeVoid, kTypeString },
	/*  923 */ { kTypeVoid, kTypeObject },
	/*  924 */ { kTypeObject, kTypeObject },
	/*  925 */ { kTypeVoid, kTypeString },
	/*  926 */ { kTypeInt, kTypeString, kTypeString, kTypeString, kTypeInt },
	/*  927 */ { kTypeFloat, kTypeString, kTypeString, kTypeString, kTypeInt },
	/*  928 */ { kTypeString, kTypeString, kTypeString, kTypeString, kTypeInt },
	/*  929 */ { kTypeVoid, kTypeString, kTypeString, kTypeString, kTypeInt, kTypeInt },
	/*  930 */ { kTypeVoid, kTypeString, kTypeString, kTypeString, kTypeInt, kTypeFloat },
	/*  931 */ { kTypeVoid, kTypeString, kTypeString, kTypeString, kTypeInt, kTypeString },
	/*  932 */ { kTypeEngineType0, kTypeInt },
	/*  933 */ { kTypeVoid, kTypeObject, kTypeString, kTypeString, kTypeFloat },
	/*  934 */ { kTypeVoid, kTypeObject, kTypeString, kTypeString, kTypeString },
	/*  935 */ { kTypeEngineType0, kTypeInt },
	/*  936 */ { kTypeObject, kTypeInt },
	/*  937 */ { kTypeInt, kTypeObject },
	/*  938 */ { kTypeObject, kTypeString },
	/*  939 */ { kTypeInt, kTypeObject },
	/*  940 */ { kTypeEngineType0 },
	/*  941 */ { kTypeEngineType0 },
	/*  942 */ { kTypeEngineType0 },
	/*  943 */ { kTypeInt, kTypeObject },
	/*  944 */ { kTypeString, kTypeObject },
	/*  945 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  946 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  947 */ { kTypeInt, kTypeObject },
	/*  948 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  949 */ { kTypeInt, kTypeObject },
	/*  950 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  951 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  952 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  953 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  954 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  955 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  956 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  957 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  958 */ { kTypeVoid, kTypeInt, kTypeObject },
	/*  959 */ { kTypeInt, kTypeObject },
	/*  960 */ { kTypeInt },
	/*  961 */ { kTypeVoid, kTypeInt },
	/*  962 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  963 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  964 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  965 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  966 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  967 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  968 */ { kTypeObject, kTypeInt, kTypeEngineType2, kTypeFloat, kTypeString, kTypeInt, kTypeString, kTypeString },
	/*  969 */ { kTypeVoid, kTypeInt, kTypeObject, kTypeInt, kTypeString, kTypeString },
	/*  970 */ { kTypeInt, kTypeInt, kTypeObject },
	/*  971 */ { kTypeInt, kTypeObject },
	/*  972 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  973 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  974 */ { kTypeObject },
	/*  975 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  976 */ { kTypeEngineType0 },
	/*  977 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  978 */ { kTypeString },
	/*  979 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  980 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  981 */ { kTypeEngineType0, kTypeObject, kTypeInt, kTypeFloat, kTypeString, kTypeInt, kTypeString },
	/*  982 */ { kTypeInt, kTypeObject },
	/*  983 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  984 */ { kTypeVoid, kTypeObject, kTypeFloat, kTypeFloat, kTypeFloat },
	/*  985 */ { kTypeFloat, kTypeObject, kTypeInt },
	/*  986 */ { kTypeInt, kTypeString },
	/*  987 */ { kTypeInt, kTypeString },
	/*  988 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  989 */ { kTypeInt, kTypeObject },
	/*  990 */ { kTypeVoid, kTypeObject, kTypeString, kTypeString, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  991 */ { kTypeVoid, kTypeObject, kTypeString, kTypeString },
	/*  992 */ { kTypeVoid, kTypeObject, kTypeString, kTypeString, kTypeString, kTypeString, kTypeString, kTypeString, kTypeString },
	/*  993 */ { kTypeVoid, kTypeObject, kTypeString, kTypeString, kTypeString },
	/*  994 */ { kTypeInt, kTypeObject },
	/*  995 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  996 */ { kTypeVoid, kTypeObject, kTypeString, kTypeString, kTypeString, kTypeString, kTypeString, kTypeString, kTypeString },
	/*  997 */ { kTypeVoid, kTypeObject },
	/*  998 */ { kTypeObject, kTypeObject, kTypeVector },
	/*  999 */ { kTypeObject, kTypeObject },
	/* 1000 */ { kTypeFloat, kTypeObject },
	/* 1001 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/* 1002 */ { kTypeString, kTypeObject },
	/* 1003 */ { kTypeInt, kTypeObject },
	/* 1004 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 1005 */ { kTypeInt, kTypeObject },
	/* 1006 */ { kTypeString, kTypeObject, kTypeInt },
	/* 1007 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 1008 */ { kTypeInt, kTypeObject },
	/* 1009 */ { kTypeInt, kTypeObject },
	/* 1010 */ { kTypeString },
	/* 1011 */ { kTypeString },
	/* 1012 */ { kTypeInt, kTypeObject },
	/* 1013 */ { kTypeInt, kTypeObject },
	/* 1014 */ { kTypeInt, kTypeString },
	/* 1015 */ { kTypeInt },
	/* 1016 */ { kTypeVoid, kTypeObject, kTypeString, kTypeString, kTypeString },
	/* 1017 */ { kTypeInt },
	/* 1018 */ { kTypeVoid, kTypeObject, kTypeString, kTypeString, kTypeInt },
	/* 1019 */ { kTypeVoid, kTypeInt },
	/* 1020 */ { kTypeInt },
	/* 1021 */ { kTypeInt, kTypeObject },
	/* 1022 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeString },
	/* 1023 */ { kTypeObject, kTypeObject },
	/* 1024 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 1025 */ { kTypeString, kTypeObject, kTypeInt },
	/* 1026 */ { kTypeFloat, kTypeObject, kTypeInt },
	/* 1027 */ { kTypeEngineType2, kTypeObject, kTypeInt },
	/* 1028 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 1029 */ { kTypeInt, kTypeObject },
	/* 1030 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 1031 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt, kTypeInt },
	/* 1032 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt, kTypeString, kTypeInt },
	/* 1033 */ { kTypeInt, kTypeEngineType2 },
	/* 1034 */ { kTypeInt, kTypeEngineType2 },
	/* 1035 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 1036 */ { kTypeInt, kTypeObject },
	/* 1037 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 1038 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/* 1039 */ { kTypeInt },
	/* 1040 */ { kTypeObject, kTypeInt },
	/* 1041 */ { kTypeVoid, kTypeObject },
	/* 1042 */ { kTypeVoid, kTypeInt },
	/* 1043 */ { kTypeVoid, kTypeString },
	/* 1044 */ { kTypeVoid, kTypeFloat },
	/* 1045 */ { kTypeVoid, kTypeObject },
	/* 1046 */ { kTypeInt, kTypeString, kTypeObject, kTypeInt },
	/* 1047 */ { kTypeVoid },
	/* 1048 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 1049 */ { kTypeInt, kTypeObject },
	/* 1050 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 1051 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 1052 */ { kTypeVoid, kTypeObject, kTypeString },
	/* 1053 */ { kTypeInt, kTypeObject },
	/* 1054 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 1055 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 1056 */ { kTypeObject, kTypeString, kTypeInt, kTypeInt },
	/* 1057 */ { kTypeVoid, kTypeObject, kTypeEngineType2 }
};

} // End of namespace NWN2

} // End of namespace NWScript

#endif // NWSCRIPT_GAME_NWN2_H
