#!/bin/bash

set -e

brew install pkg-config || true
brew link --overwrite pkg-config

# install cmake if it has not yet been installed
cmake --version || brew install cmake

brew install \
  docbook-xsl \
  fftw wavpack \
  gettext \
  imagemagick \
  jack \
  wxwidgets \
  yaml-cpp
brew link gettext --force

# A workaround of https://gitlab.kitware.com/cmake/cmake/-/issues/23826
for F in $(grep -l '(, weak)\?'  {/usr/local,/opt/homebrew}/Cellar/cmake/*/share/cmake/Modules/GetPrerequisites.cmake); do
  echo Patching $F...
  # macOS sed does not support the -i option
  sed -e 's/(, weak)\?/(, (weak|reexport))?/' $F >${F}.new
  mv ${F}.new $F
done
